/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.impl.io;

import java.io.IOException;
import org.elasticsearch.client.http.HttpException;
import org.elasticsearch.client.http.HttpResponse;
import org.elasticsearch.client.http.HttpResponseFactory;
import org.elasticsearch.client.http.NoHttpResponseException;
import org.elasticsearch.client.http.ParseException;
import org.elasticsearch.client.http.StatusLine;
import org.elasticsearch.client.http.config.MessageConstraints;
import org.elasticsearch.client.http.impl.DefaultHttpResponseFactory;
import org.elasticsearch.client.http.impl.io.AbstractMessageParser;
import org.elasticsearch.client.http.io.SessionInputBuffer;
import org.elasticsearch.client.http.message.LineParser;
import org.elasticsearch.client.http.message.ParserCursor;
import org.elasticsearch.client.http.params.HttpParams;
import org.elasticsearch.client.http.util.Args;
import org.elasticsearch.client.http.util.CharArrayBuffer;

public class DefaultHttpResponseParser
extends AbstractMessageParser<HttpResponse> {
    private final HttpResponseFactory responseFactory;
    private final CharArrayBuffer lineBuf;

    @Deprecated
    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser lineParser, HttpResponseFactory responseFactory, HttpParams params) {
        super(buffer, lineParser, params);
        this.responseFactory = Args.notNull(responseFactory, "Response factory");
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser lineParser, HttpResponseFactory responseFactory, MessageConstraints constraints) {
        super(buffer, lineParser, constraints);
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer, MessageConstraints constraints) {
        this(buffer, null, null, constraints);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer) {
        this(buffer, null, null, MessageConstraints.DEFAULT);
    }

    @Override
    protected HttpResponse parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException, ParseException {
        this.lineBuf.clear();
        int i = sessionBuffer.readLine(this.lineBuf);
        if (i == -1) {
            throw new NoHttpResponseException("The target server failed to respond");
        }
        ParserCursor cursor = new ParserCursor(0, this.lineBuf.length());
        StatusLine statusline = this.lineParser.parseStatusLine(this.lineBuf, cursor);
        return this.responseFactory.newHttpResponse(statusline, null);
    }
}

