/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.impl.io;

import org.elasticsearch.client.http.HttpResponse;
import org.elasticsearch.client.http.annotation.Contract;
import org.elasticsearch.client.http.annotation.ThreadingBehavior;
import org.elasticsearch.client.http.impl.io.DefaultHttpResponseWriter;
import org.elasticsearch.client.http.io.HttpMessageWriter;
import org.elasticsearch.client.http.io.HttpMessageWriterFactory;
import org.elasticsearch.client.http.io.SessionOutputBuffer;
import org.elasticsearch.client.http.message.BasicLineFormatter;
import org.elasticsearch.client.http.message.LineFormatter;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseWriterFactory
implements HttpMessageWriterFactory<HttpResponse> {
    public static final DefaultHttpResponseWriterFactory INSTANCE = new DefaultHttpResponseWriterFactory();
    private final LineFormatter lineFormatter;

    public DefaultHttpResponseWriterFactory(LineFormatter lineFormatter) {
        this.lineFormatter = lineFormatter != null ? lineFormatter : BasicLineFormatter.INSTANCE;
    }

    public DefaultHttpResponseWriterFactory() {
        this(null);
    }

    @Override
    public HttpMessageWriter<HttpResponse> create(SessionOutputBuffer buffer) {
        return new DefaultHttpResponseWriter(buffer, this.lineFormatter);
    }
}

