/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.impl.nio;

import org.elasticsearch.client.http.HttpRequest;
import org.elasticsearch.client.http.HttpRequestFactory;
import org.elasticsearch.client.http.HttpResponse;
import org.elasticsearch.client.http.annotation.Contract;
import org.elasticsearch.client.http.annotation.ThreadingBehavior;
import org.elasticsearch.client.http.config.ConnectionConfig;
import org.elasticsearch.client.http.entity.ContentLengthStrategy;
import org.elasticsearch.client.http.impl.ConnSupport;
import org.elasticsearch.client.http.impl.DefaultHttpRequestFactory;
import org.elasticsearch.client.http.impl.nio.DefaultNHttpServerConnection;
import org.elasticsearch.client.http.impl.nio.codecs.DefaultHttpRequestParserFactory;
import org.elasticsearch.client.http.nio.NHttpConnectionFactory;
import org.elasticsearch.client.http.nio.NHttpMessageParserFactory;
import org.elasticsearch.client.http.nio.NHttpMessageWriterFactory;
import org.elasticsearch.client.http.nio.reactor.IOSession;
import org.elasticsearch.client.http.nio.util.ByteBufferAllocator;
import org.elasticsearch.client.http.nio.util.HeapByteBufferAllocator;
import org.elasticsearch.client.http.params.HttpParamConfig;
import org.elasticsearch.client.http.params.HttpParams;
import org.elasticsearch.client.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultNHttpServerConnectionFactory
implements NHttpConnectionFactory<DefaultNHttpServerConnection> {
    private final ContentLengthStrategy incomingContentStrategy;
    private final ContentLengthStrategy outgoingContentStrategy;
    private final NHttpMessageParserFactory<HttpRequest> requestParserFactory;
    private final NHttpMessageWriterFactory<HttpResponse> responseWriterFactory;
    private final ByteBufferAllocator allocator;
    private final ConnectionConfig cconfig;

    @Deprecated
    public DefaultNHttpServerConnectionFactory(HttpRequestFactory requestFactory, ByteBufferAllocator allocator, HttpParams params) {
        Args.notNull(requestFactory, "HTTP request factory");
        Args.notNull(allocator, "Byte buffer allocator");
        Args.notNull(params, "HTTP parameters");
        this.incomingContentStrategy = null;
        this.outgoingContentStrategy = null;
        this.requestParserFactory = new DefaultHttpRequestParserFactory(null, requestFactory);
        this.responseWriterFactory = null;
        this.allocator = allocator;
        this.cconfig = HttpParamConfig.getConnectionConfig(params);
    }

    @Deprecated
    public DefaultNHttpServerConnectionFactory(HttpParams params) {
        this(DefaultHttpRequestFactory.INSTANCE, HeapByteBufferAllocator.INSTANCE, params);
    }

    @Deprecated
    protected DefaultNHttpServerConnection createConnection(IOSession session, HttpRequestFactory requestFactory, ByteBufferAllocator allocator, HttpParams params) {
        return new DefaultNHttpServerConnection(session, requestFactory, allocator, params);
    }

    public DefaultNHttpServerConnectionFactory(ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, NHttpMessageParserFactory<HttpRequest> requestParserFactory, NHttpMessageWriterFactory<HttpResponse> responseWriterFactory, ByteBufferAllocator allocator, ConnectionConfig cconfig) {
        this.incomingContentStrategy = incomingContentStrategy;
        this.outgoingContentStrategy = outgoingContentStrategy;
        this.requestParserFactory = requestParserFactory;
        this.responseWriterFactory = responseWriterFactory;
        this.allocator = allocator;
        this.cconfig = cconfig != null ? cconfig : ConnectionConfig.DEFAULT;
    }

    public DefaultNHttpServerConnectionFactory(ByteBufferAllocator allocator, NHttpMessageParserFactory<HttpRequest> requestParserFactory, NHttpMessageWriterFactory<HttpResponse> responseWriterFactory, ConnectionConfig cconfig) {
        this(null, null, requestParserFactory, responseWriterFactory, allocator, cconfig);
    }

    public DefaultNHttpServerConnectionFactory(ConnectionConfig config) {
        this(null, null, null, null, null, config);
    }

    public DefaultNHttpServerConnectionFactory() {
        this(null, null, null, null, null, null);
    }

    @Override
    public DefaultNHttpServerConnection createConnection(IOSession session) {
        return new DefaultNHttpServerConnection(session, this.cconfig.getBufferSize(), this.cconfig.getFragmentSizeHint(), this.allocator, ConnSupport.createDecoder(this.cconfig), ConnSupport.createEncoder(this.cconfig), this.cconfig.getMessageConstraints(), this.incomingContentStrategy, this.outgoingContentStrategy, this.requestParserFactory, this.responseWriterFactory);
    }
}

