/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.impl.nio.client;

import java.io.Closeable;
import java.net.URI;
import java.util.concurrent.Future;
import org.elasticsearch.client.http.HttpHost;
import org.elasticsearch.client.http.HttpRequest;
import org.elasticsearch.client.http.HttpResponse;
import org.elasticsearch.client.http.annotation.Contract;
import org.elasticsearch.client.http.annotation.ThreadingBehavior;
import org.elasticsearch.client.http.client.ClientProtocolException;
import org.elasticsearch.client.http.client.methods.HttpUriRequest;
import org.elasticsearch.client.http.client.protocol.HttpClientContext;
import org.elasticsearch.client.http.client.utils.URIUtils;
import org.elasticsearch.client.http.concurrent.BasicFuture;
import org.elasticsearch.client.http.concurrent.FutureCallback;
import org.elasticsearch.client.http.nio.client.HttpAsyncClient;
import org.elasticsearch.client.http.nio.client.methods.HttpAsyncMethods;
import org.elasticsearch.client.http.nio.protocol.HttpAsyncRequestProducer;
import org.elasticsearch.client.http.nio.protocol.HttpAsyncResponseConsumer;
import org.elasticsearch.client.http.protocol.HttpContext;
import org.elasticsearch.client.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public abstract class CloseableHttpAsyncClient
implements HttpAsyncClient,
Closeable {
    public abstract boolean isRunning();

    public abstract void start();

    @Override
    public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, FutureCallback<T> callback) {
        return this.execute(requestProducer, responseConsumer, (HttpContext)HttpClientContext.create(), callback);
    }

    @Override
    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        return this.execute(HttpAsyncMethods.create(target, request), HttpAsyncMethods.createConsumer(), context, callback);
    }

    @Override
    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, FutureCallback<HttpResponse> callback) {
        return this.execute(target, request, (HttpContext)HttpClientContext.create(), callback);
    }

    @Override
    public Future<HttpResponse> execute(HttpUriRequest request, FutureCallback<HttpResponse> callback) {
        return this.execute(request, HttpClientContext.create(), callback);
    }

    @Override
    public Future<HttpResponse> execute(HttpUriRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        HttpHost target;
        try {
            target = this.determineTarget(request);
        }
        catch (ClientProtocolException ex) {
            BasicFuture<HttpResponse> future = new BasicFuture<HttpResponse>(callback);
            future.failed(ex);
            return future;
        }
        return this.execute(target, request, context, callback);
    }

    private HttpHost determineTarget(HttpUriRequest request) throws ClientProtocolException {
        Args.notNull(request, "HTTP request");
        HttpHost target = null;
        URI requestURI = request.getURI();
        if (requestURI.isAbsolute() && (target = URIUtils.extractHost(requestURI)) == null) {
            throw new ClientProtocolException("URI does not specify a valid host name: " + requestURI);
        }
        return target;
    }
}

