/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.impl.nio.client;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.elasticsearch.client.http.HttpHost;
import org.elasticsearch.client.http.HttpRequest;
import org.elasticsearch.client.http.HttpResponse;
import org.elasticsearch.client.http.annotation.Contract;
import org.elasticsearch.client.http.annotation.ThreadingBehavior;
import org.elasticsearch.client.http.client.protocol.HttpClientContext;
import org.elasticsearch.client.http.concurrent.FutureCallback;
import org.elasticsearch.client.http.impl.nio.client.CloseableHttpAsyncClient;
import org.elasticsearch.client.http.nio.client.HttpPipeliningClient;
import org.elasticsearch.client.http.nio.client.methods.HttpAsyncMethods;
import org.elasticsearch.client.http.nio.protocol.HttpAsyncRequestProducer;
import org.elasticsearch.client.http.nio.protocol.HttpAsyncResponseConsumer;
import org.elasticsearch.client.http.protocol.HttpContext;
import org.elasticsearch.client.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public abstract class CloseableHttpPipeliningClient
extends CloseableHttpAsyncClient
implements HttpPipeliningClient {
    @Override
    public <T> Future<List<T>> execute(HttpHost target, List<? extends HttpAsyncRequestProducer> requestProducers, List<? extends HttpAsyncResponseConsumer<T>> responseConsumers, FutureCallback<List<T>> callback) {
        return this.execute(target, requestProducers, responseConsumers, HttpClientContext.create(), callback);
    }

    @Override
    public Future<List<HttpResponse>> execute(HttpHost target, List<HttpRequest> requests, FutureCallback<List<HttpResponse>> callback) {
        return this.execute(target, requests, (HttpContext)HttpClientContext.create(), callback);
    }

    @Override
    public Future<List<HttpResponse>> execute(HttpHost target, List<HttpRequest> requests, HttpContext context, FutureCallback<List<HttpResponse>> callback) {
        Args.notEmpty(requests, "HTTP request list");
        ArrayList<HttpAsyncRequestProducer> requestProducers = new ArrayList<HttpAsyncRequestProducer>(requests.size());
        ArrayList<HttpAsyncResponseConsumer<HttpResponse>> responseConsumers = new ArrayList<HttpAsyncResponseConsumer<HttpResponse>>(requests.size());
        for (int i = 0; i < requests.size(); ++i) {
            HttpRequest request = requests.get(i);
            requestProducers.add(HttpAsyncMethods.create(target, request));
            responseConsumers.add(HttpAsyncMethods.createConsumer());
        }
        return this.execute(target, requestProducers, responseConsumers, context, callback);
    }
}

