/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.impl.nio.client;

import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.elasticsearch.client.commons.logging.Log;
import org.elasticsearch.client.commons.logging.LogFactory;
import org.elasticsearch.client.http.ConnectionReuseStrategy;
import org.elasticsearch.client.http.HttpHost;
import org.elasticsearch.client.http.auth.AuthSchemeProvider;
import org.elasticsearch.client.http.auth.AuthState;
import org.elasticsearch.client.http.client.CookieStore;
import org.elasticsearch.client.http.client.CredentialsProvider;
import org.elasticsearch.client.http.client.config.RequestConfig;
import org.elasticsearch.client.http.client.protocol.HttpClientContext;
import org.elasticsearch.client.http.concurrent.BasicFuture;
import org.elasticsearch.client.http.concurrent.FutureCallback;
import org.elasticsearch.client.http.config.Lookup;
import org.elasticsearch.client.http.conn.ConnectionKeepAliveStrategy;
import org.elasticsearch.client.http.cookie.CookieSpecProvider;
import org.elasticsearch.client.http.impl.nio.client.CloseableHttpAsyncClientBase;
import org.elasticsearch.client.http.impl.nio.client.DefaultClientExchangeHandlerImpl;
import org.elasticsearch.client.http.impl.nio.client.InternalClientExec;
import org.elasticsearch.client.http.nio.NHttpClientEventHandler;
import org.elasticsearch.client.http.nio.conn.NHttpClientConnectionManager;
import org.elasticsearch.client.http.nio.protocol.HttpAsyncRequestProducer;
import org.elasticsearch.client.http.nio.protocol.HttpAsyncResponseConsumer;
import org.elasticsearch.client.http.protocol.BasicHttpContext;
import org.elasticsearch.client.http.protocol.HttpContext;

class InternalHttpAsyncClient
extends CloseableHttpAsyncClientBase {
    private final Log log = LogFactory.getLog(this.getClass());
    private final NHttpClientConnectionManager connmgr;
    private final ConnectionReuseStrategy connReuseStrategy;
    private final ConnectionKeepAliveStrategy keepaliveStrategy;
    private final InternalClientExec exec;
    private final Lookup<CookieSpecProvider> cookieSpecRegistry;
    private final Lookup<AuthSchemeProvider> authSchemeRegistry;
    private final CookieStore cookieStore;
    private final CredentialsProvider credentialsProvider;
    private final RequestConfig defaultConfig;

    public InternalHttpAsyncClient(NHttpClientConnectionManager connmgr, ConnectionReuseStrategy connReuseStrategy, ConnectionKeepAliveStrategy keepaliveStrategy, ThreadFactory threadFactory, NHttpClientEventHandler handler, InternalClientExec exec, Lookup<CookieSpecProvider> cookieSpecRegistry, Lookup<AuthSchemeProvider> authSchemeRegistry, CookieStore cookieStore, CredentialsProvider credentialsProvider, RequestConfig defaultConfig) {
        super(connmgr, threadFactory, handler);
        this.connmgr = connmgr;
        this.connReuseStrategy = connReuseStrategy;
        this.keepaliveStrategy = keepaliveStrategy;
        this.exec = exec;
        this.cookieSpecRegistry = cookieSpecRegistry;
        this.authSchemeRegistry = authSchemeRegistry;
        this.cookieStore = cookieStore;
        this.credentialsProvider = credentialsProvider;
        this.defaultConfig = defaultConfig;
    }

    private void setupContext(HttpClientContext context) {
        if (context.getAttribute("http.auth.target-scope") == null) {
            context.setAttribute("http.auth.target-scope", new AuthState());
        }
        if (context.getAttribute("http.auth.proxy-scope") == null) {
            context.setAttribute("http.auth.proxy-scope", new AuthState());
        }
        if (context.getAttribute("http.authscheme-registry") == null) {
            context.setAttribute("http.authscheme-registry", this.authSchemeRegistry);
        }
        if (context.getAttribute("http.cookiespec-registry") == null) {
            context.setAttribute("http.cookiespec-registry", this.cookieSpecRegistry);
        }
        if (context.getAttribute("http.cookie-store") == null) {
            context.setAttribute("http.cookie-store", this.cookieStore);
        }
        if (context.getAttribute("http.auth.credentials-provider") == null) {
            context.setAttribute("http.auth.credentials-provider", this.credentialsProvider);
        }
        if (context.getAttribute("http.request-config") == null) {
            context.setAttribute("http.request-config", this.defaultConfig);
        }
    }

    @Override
    public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
        this.ensureRunning();
        BasicFuture<T> future = new BasicFuture<T>(callback);
        HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
        this.setupContext(localcontext);
        DefaultClientExchangeHandlerImpl<T> handler = new DefaultClientExchangeHandlerImpl<T>(this.log, requestProducer, responseConsumer, localcontext, future, this.connmgr, this.connReuseStrategy, this.keepaliveStrategy, this.exec);
        try {
            handler.start();
        }
        catch (Exception ex) {
            handler.failed(ex);
        }
        return future;
    }

    @Override
    public <T> Future<List<T>> execute(HttpHost target, List<? extends HttpAsyncRequestProducer> requestProducers, List<? extends HttpAsyncResponseConsumer<T>> responseConsumers, HttpContext context, FutureCallback<List<T>> callback) {
        throw new UnsupportedOperationException("Pipelining not supported");
    }
}

