/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.impl.nio.client;

import java.io.IOException;
import org.elasticsearch.client.commons.logging.Log;
import org.elasticsearch.client.commons.logging.LogFactory;
import org.elasticsearch.client.http.impl.nio.DefaultNHttpClientConnection;
import org.elasticsearch.client.http.impl.nio.client.InternalRequestExecutor;
import org.elasticsearch.client.http.impl.nio.reactor.AbstractIODispatch;
import org.elasticsearch.client.http.nio.NHttpClientEventHandler;
import org.elasticsearch.client.http.nio.reactor.IOSession;

class InternalIODispatch
extends AbstractIODispatch<DefaultNHttpClientConnection> {
    private final Log log = LogFactory.getLog(InternalIODispatch.class);
    private final NHttpClientEventHandler handler;

    public InternalIODispatch(NHttpClientEventHandler handler) {
        this.handler = this.log.isDebugEnabled() ? new InternalRequestExecutor(this.log, handler) : handler;
    }

    @Override
    protected DefaultNHttpClientConnection createConnection(IOSession session) {
        throw new IllegalStateException("Connection must be created by connection manager");
    }

    @Override
    protected void onConnected(DefaultNHttpClientConnection conn) {
        Object attachment = conn.getContext().getAttribute("http.session.attachment");
        try {
            this.handler.connected(conn, attachment);
        }
        catch (Exception ex) {
            this.handler.exception(conn, ex);
        }
    }

    @Override
    protected void onClosed(DefaultNHttpClientConnection conn) {
        this.handler.closed(conn);
    }

    @Override
    protected void onException(DefaultNHttpClientConnection conn, IOException ex) {
        this.handler.exception(conn, ex);
    }

    @Override
    protected void onInputReady(DefaultNHttpClientConnection conn) {
        conn.consumeInput(this.handler);
    }

    @Override
    protected void onOutputReady(DefaultNHttpClientConnection conn) {
        conn.produceOutput(this.handler);
    }

    @Override
    protected void onTimeout(DefaultNHttpClientConnection conn) {
        try {
            this.handler.timeout(conn);
        }
        catch (Exception ex) {
            this.handler.exception(conn, ex);
        }
    }
}

