/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.impl.nio.codecs;

import java.io.IOException;
import org.elasticsearch.client.http.Header;
import org.elasticsearch.client.http.HeaderIterator;
import org.elasticsearch.client.http.HttpException;
import org.elasticsearch.client.http.HttpMessage;
import org.elasticsearch.client.http.message.BasicLineFormatter;
import org.elasticsearch.client.http.message.LineFormatter;
import org.elasticsearch.client.http.nio.NHttpMessageWriter;
import org.elasticsearch.client.http.nio.reactor.SessionOutputBuffer;
import org.elasticsearch.client.http.params.HttpParams;
import org.elasticsearch.client.http.util.Args;
import org.elasticsearch.client.http.util.CharArrayBuffer;

public abstract class AbstractMessageWriter<T extends HttpMessage>
implements NHttpMessageWriter<T> {
    protected final SessionOutputBuffer sessionBuffer;
    protected final CharArrayBuffer lineBuf;
    protected final LineFormatter lineFormatter;

    @Deprecated
    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter, HttpParams params) {
        Args.notNull(buffer, "Session input buffer");
        this.sessionBuffer = buffer;
        this.lineBuf = new CharArrayBuffer(64);
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
    }

    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter) {
        this.sessionBuffer = Args.notNull(buffer, "Session input buffer");
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
        this.lineBuf = new CharArrayBuffer(64);
    }

    @Override
    public void reset() {
    }

    protected abstract void writeHeadLine(T var1) throws IOException;

    @Override
    public void write(T message) throws IOException, HttpException {
        Args.notNull(message, "HTTP message");
        this.writeHeadLine(message);
        HeaderIterator it = message.headerIterator();
        while (it.hasNext()) {
            Header header = (Header)it.next();
            this.sessionBuffer.writeLine(this.lineFormatter.formatHeader(this.lineBuf, header));
        }
        this.lineBuf.clear();
        this.sessionBuffer.writeLine(this.lineBuf);
    }
}

