/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.impl.nio.codecs;

import org.elasticsearch.client.http.HttpRequest;
import org.elasticsearch.client.http.HttpRequestFactory;
import org.elasticsearch.client.http.annotation.Contract;
import org.elasticsearch.client.http.annotation.ThreadingBehavior;
import org.elasticsearch.client.http.config.MessageConstraints;
import org.elasticsearch.client.http.impl.DefaultHttpRequestFactory;
import org.elasticsearch.client.http.impl.nio.codecs.DefaultHttpRequestParser;
import org.elasticsearch.client.http.message.BasicLineParser;
import org.elasticsearch.client.http.message.LineParser;
import org.elasticsearch.client.http.nio.NHttpMessageParser;
import org.elasticsearch.client.http.nio.NHttpMessageParserFactory;
import org.elasticsearch.client.http.nio.reactor.SessionInputBuffer;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpRequestParserFactory
implements NHttpMessageParserFactory<HttpRequest> {
    public static final DefaultHttpRequestParserFactory INSTANCE = new DefaultHttpRequestParserFactory();
    private final LineParser lineParser;
    private final HttpRequestFactory requestFactory;

    public DefaultHttpRequestParserFactory(LineParser lineParser, HttpRequestFactory requestFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.requestFactory = requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE;
    }

    public DefaultHttpRequestParserFactory() {
        this(null, null);
    }

    @Override
    public NHttpMessageParser<HttpRequest> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpRequestParser(buffer, this.lineParser, this.requestFactory, constraints);
    }
}

