/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.impl.nio.codecs;

import org.elasticsearch.client.http.HttpResponse;
import org.elasticsearch.client.http.annotation.Contract;
import org.elasticsearch.client.http.annotation.ThreadingBehavior;
import org.elasticsearch.client.http.impl.nio.codecs.DefaultHttpResponseWriter;
import org.elasticsearch.client.http.message.BasicLineFormatter;
import org.elasticsearch.client.http.message.LineFormatter;
import org.elasticsearch.client.http.nio.NHttpMessageWriter;
import org.elasticsearch.client.http.nio.NHttpMessageWriterFactory;
import org.elasticsearch.client.http.nio.reactor.SessionOutputBuffer;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseWriterFactory
implements NHttpMessageWriterFactory<HttpResponse> {
    public static final DefaultHttpResponseWriterFactory INSTANCE = new DefaultHttpResponseWriterFactory();
    private final LineFormatter lineFormatter;

    public DefaultHttpResponseWriterFactory(LineFormatter lineFormatter) {
        this.lineFormatter = lineFormatter != null ? lineFormatter : BasicLineFormatter.INSTANCE;
    }

    public DefaultHttpResponseWriterFactory() {
        this(null);
    }

    @Override
    public NHttpMessageWriter<HttpResponse> create(SessionOutputBuffer buffer) {
        return new DefaultHttpResponseWriter(buffer, this.lineFormatter);
    }
}

