/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.impl.nio.conn;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.client.commons.logging.Log;
import org.elasticsearch.client.commons.logging.LogFactory;
import org.elasticsearch.client.http.HttpRequest;
import org.elasticsearch.client.http.HttpResponse;
import org.elasticsearch.client.http.config.ConnectionConfig;
import org.elasticsearch.client.http.impl.nio.codecs.DefaultHttpRequestWriterFactory;
import org.elasticsearch.client.http.impl.nio.codecs.DefaultHttpResponseParserFactory;
import org.elasticsearch.client.http.impl.nio.conn.ManagedNHttpClientConnectionImpl;
import org.elasticsearch.client.http.nio.NHttpMessageParserFactory;
import org.elasticsearch.client.http.nio.NHttpMessageWriterFactory;
import org.elasticsearch.client.http.nio.conn.ManagedNHttpClientConnection;
import org.elasticsearch.client.http.nio.conn.NHttpConnectionFactory;
import org.elasticsearch.client.http.nio.reactor.IOSession;
import org.elasticsearch.client.http.nio.util.ByteBufferAllocator;
import org.elasticsearch.client.http.nio.util.HeapByteBufferAllocator;

public class ManagedNHttpClientConnectionFactory
implements NHttpConnectionFactory<ManagedNHttpClientConnection> {
    private final Log headerlog = LogFactory.getLog("org.elasticsearch.client.http.headers");
    private final Log wirelog = LogFactory.getLog("org.elasticsearch.client.http.wire");
    private final Log log = LogFactory.getLog(ManagedNHttpClientConnectionImpl.class);
    private static final AtomicLong COUNTER = new AtomicLong();
    public static final ManagedNHttpClientConnectionFactory INSTANCE = new ManagedNHttpClientConnectionFactory();
    private final ByteBufferAllocator allocator;
    private final NHttpMessageWriterFactory<HttpRequest> requestWriterFactory;
    private final NHttpMessageParserFactory<HttpResponse> responseParserFactory;

    public ManagedNHttpClientConnectionFactory(NHttpMessageWriterFactory<HttpRequest> requestWriterFactory, NHttpMessageParserFactory<HttpResponse> responseParserFactory, ByteBufferAllocator allocator) {
        this.requestWriterFactory = requestWriterFactory != null ? requestWriterFactory : DefaultHttpRequestWriterFactory.INSTANCE;
        this.responseParserFactory = responseParserFactory != null ? responseParserFactory : DefaultHttpResponseParserFactory.INSTANCE;
        this.allocator = allocator != null ? allocator : HeapByteBufferAllocator.INSTANCE;
    }

    public ManagedNHttpClientConnectionFactory() {
        this(null, null, null);
    }

    @Override
    public ManagedNHttpClientConnection create(IOSession iosession, ConnectionConfig config) {
        CodingErrorAction unmappableInputAction;
        String id = "http-outgoing-" + Long.toString(COUNTER.getAndIncrement());
        CharsetDecoder chardecoder = null;
        CharsetEncoder charencoder = null;
        Charset charset = config.getCharset();
        CodingErrorAction malformedInputAction = config.getMalformedInputAction() != null ? config.getMalformedInputAction() : CodingErrorAction.REPORT;
        CodingErrorAction codingErrorAction = unmappableInputAction = config.getUnmappableInputAction() != null ? config.getUnmappableInputAction() : CodingErrorAction.REPORT;
        if (charset != null) {
            chardecoder = charset.newDecoder();
            chardecoder.onMalformedInput(malformedInputAction);
            chardecoder.onUnmappableCharacter(unmappableInputAction);
            charencoder = charset.newEncoder();
            charencoder.onMalformedInput(malformedInputAction);
            charencoder.onUnmappableCharacter(unmappableInputAction);
        }
        ManagedNHttpClientConnectionImpl conn = new ManagedNHttpClientConnectionImpl(id, this.log, this.headerlog, this.wirelog, iosession, config.getBufferSize(), config.getFragmentSizeHint(), this.allocator, chardecoder, charencoder, config.getMessageConstraints(), null, null, this.requestWriterFactory, this.responseParserFactory);
        iosession.setAttribute("http.connection", conn);
        return conn;
    }
}

