/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.impl.nio.conn;

import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import javax.net.ssl.SSLSession;
import org.elasticsearch.client.commons.logging.Log;
import org.elasticsearch.client.http.Header;
import org.elasticsearch.client.http.HttpRequest;
import org.elasticsearch.client.http.HttpResponse;
import org.elasticsearch.client.http.config.MessageConstraints;
import org.elasticsearch.client.http.entity.ContentLengthStrategy;
import org.elasticsearch.client.http.impl.nio.DefaultNHttpClientConnection;
import org.elasticsearch.client.http.impl.nio.conn.LoggingIOSession;
import org.elasticsearch.client.http.nio.NHttpMessageParserFactory;
import org.elasticsearch.client.http.nio.NHttpMessageWriterFactory;
import org.elasticsearch.client.http.nio.conn.ManagedNHttpClientConnection;
import org.elasticsearch.client.http.nio.reactor.IOSession;
import org.elasticsearch.client.http.nio.reactor.ssl.SSLIOSession;
import org.elasticsearch.client.http.nio.util.ByteBufferAllocator;
import org.elasticsearch.client.http.util.Args;
import org.elasticsearch.client.http.util.Asserts;

class ManagedNHttpClientConnectionImpl
extends DefaultNHttpClientConnection
implements ManagedNHttpClientConnection {
    private final Log headerlog;
    private final Log wirelog;
    private final Log log;
    private final String id;
    private IOSession original;

    public ManagedNHttpClientConnectionImpl(String id, Log log, Log headerlog, Log wirelog, IOSession iosession, int buffersize, int fragmentSizeHint, ByteBufferAllocator allocator, CharsetDecoder chardecoder, CharsetEncoder charencoder, MessageConstraints constraints, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, NHttpMessageWriterFactory<HttpRequest> requestWriterFactory, NHttpMessageParserFactory<HttpResponse> responseParserFactory) {
        super(iosession, buffersize, fragmentSizeHint, allocator, chardecoder, charencoder, constraints, incomingContentStrategy, outgoingContentStrategy, requestWriterFactory, responseParserFactory);
        this.id = id;
        this.log = log;
        this.headerlog = headerlog;
        this.wirelog = wirelog;
        this.original = iosession;
        if (this.log.isDebugEnabled() || this.wirelog.isDebugEnabled()) {
            super.bind(new LoggingIOSession(iosession, this.id, this.log, this.wirelog));
        }
    }

    @Override
    public void bind(IOSession iosession) {
        Args.notNull(iosession, "I/O session");
        Asserts.check(!iosession.isClosed(), "I/O session is closed");
        this.status = 0;
        this.original = iosession;
        if (this.log.isDebugEnabled() || this.wirelog.isDebugEnabled()) {
            this.log.debug(this.id + " Upgrade session " + iosession);
            super.bind(new LoggingIOSession(iosession, this.id, this.log, this.wirelog));
        } else {
            super.bind(iosession);
        }
    }

    @Override
    public IOSession getIOSession() {
        return this.original;
    }

    @Override
    public SSLSession getSSLSession() {
        if (this.original instanceof SSLIOSession) {
            return ((SSLIOSession)this.original).getSSLSession();
        }
        return null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    protected void onResponseReceived(HttpResponse response) {
        if (response != null && this.headerlog.isDebugEnabled()) {
            Header[] headers;
            this.headerlog.debug(this.id + " << " + response.getStatusLine().toString());
            for (Header header : headers = response.getAllHeaders()) {
                this.headerlog.debug(this.id + " << " + header.toString());
            }
        }
    }

    @Override
    protected void onRequestSubmitted(HttpRequest request) {
        if (request != null && this.headerlog.isDebugEnabled()) {
            Header[] headers;
            this.headerlog.debug(this.id + " >> " + request.getRequestLine().toString());
            for (Header header : headers = request.getAllHeaders()) {
                this.headerlog.debug(this.id + " >> " + header.toString());
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.id);
        buf.append(" [");
        switch (this.status) {
            case 0: {
                buf.append("ACTIVE");
                if (!this.inbuf.hasData()) break;
                buf.append("(").append(this.inbuf.length()).append(")");
                break;
            }
            case 1: {
                buf.append("CLOSING");
                break;
            }
            case 2: {
                buf.append("CLOSED");
            }
        }
        buf.append("]");
        return buf.toString();
    }
}

