/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.impl.nio.pool;

import java.io.IOException;
import org.elasticsearch.client.http.HttpHost;
import org.elasticsearch.client.http.annotation.Contract;
import org.elasticsearch.client.http.annotation.ThreadingBehavior;
import org.elasticsearch.client.http.nio.NHttpClientConnection;
import org.elasticsearch.client.http.pool.PoolEntry;

@Contract(threading=ThreadingBehavior.SAFE)
public class BasicNIOPoolEntry
extends PoolEntry<HttpHost, NHttpClientConnection> {
    private volatile int socketTimeout;

    public BasicNIOPoolEntry(String id, HttpHost route, NHttpClientConnection conn) {
        super(id, route, conn);
    }

    @Override
    public void close() {
        try {
            ((NHttpClientConnection)this.getConnection()).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isClosed() {
        return !((NHttpClientConnection)this.getConnection()).isOpen();
    }

    int getSocketTimeout() {
        return this.socketTimeout;
    }

    void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }
}

