/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.impl.pool;

import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.client.http.HttpClientConnection;
import org.elasticsearch.client.http.HttpHost;
import org.elasticsearch.client.http.annotation.Contract;
import org.elasticsearch.client.http.annotation.ThreadingBehavior;
import org.elasticsearch.client.http.config.ConnectionConfig;
import org.elasticsearch.client.http.config.SocketConfig;
import org.elasticsearch.client.http.impl.pool.BasicConnFactory;
import org.elasticsearch.client.http.impl.pool.BasicPoolEntry;
import org.elasticsearch.client.http.params.HttpParams;
import org.elasticsearch.client.http.pool.AbstractConnPool;
import org.elasticsearch.client.http.pool.ConnFactory;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class BasicConnPool
extends AbstractConnPool<HttpHost, HttpClientConnection, BasicPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong();

    public BasicConnPool(ConnFactory<HttpHost, HttpClientConnection> connFactory) {
        super(connFactory, 2, 20);
    }

    @Deprecated
    public BasicConnPool(HttpParams params) {
        super(new BasicConnFactory(params), 2, 20);
    }

    public BasicConnPool(SocketConfig sconfig, ConnectionConfig cconfig) {
        super(new BasicConnFactory(sconfig, cconfig), 2, 20);
    }

    public BasicConnPool() {
        super(new BasicConnFactory(SocketConfig.DEFAULT, ConnectionConfig.DEFAULT), 2, 20);
    }

    @Override
    protected BasicPoolEntry createEntry(HttpHost host, HttpClientConnection conn) {
        return new BasicPoolEntry(Long.toString(COUNTER.getAndIncrement()), host, conn);
    }

    @Override
    protected boolean validate(BasicPoolEntry entry) {
        return !((HttpClientConnection)entry.getConnection()).isStale();
    }
}

