/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.nio.protocol;

import java.io.IOException;
import org.elasticsearch.client.http.ContentTooLongException;
import org.elasticsearch.client.http.HttpEntity;
import org.elasticsearch.client.http.HttpEntityEnclosingRequest;
import org.elasticsearch.client.http.HttpRequest;
import org.elasticsearch.client.http.entity.ContentType;
import org.elasticsearch.client.http.nio.ContentDecoder;
import org.elasticsearch.client.http.nio.IOControl;
import org.elasticsearch.client.http.nio.entity.ContentBufferEntity;
import org.elasticsearch.client.http.nio.protocol.AbstractAsyncRequestConsumer;
import org.elasticsearch.client.http.nio.util.HeapByteBufferAllocator;
import org.elasticsearch.client.http.nio.util.SimpleInputBuffer;
import org.elasticsearch.client.http.protocol.HttpContext;
import org.elasticsearch.client.http.util.Asserts;

public class BasicAsyncRequestConsumer
extends AbstractAsyncRequestConsumer<HttpRequest> {
    private volatile HttpRequest request;
    private volatile SimpleInputBuffer buf;

    @Override
    protected void onRequestReceived(HttpRequest request) throws IOException {
        this.request = request;
    }

    @Override
    protected void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        long len = entity.getContentLength();
        if (len > Integer.MAX_VALUE) {
            throw new ContentTooLongException("Entity content is too long: " + len);
        }
        if (len < 0L) {
            len = 4096L;
        }
        this.buf = new SimpleInputBuffer((int)len, new HeapByteBufferAllocator());
        ((HttpEntityEnclosingRequest)this.request).setEntity(new ContentBufferEntity(entity, this.buf));
    }

    @Override
    protected void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        Asserts.notNull(this.buf, "Content buffer");
        this.buf.consumeContent(decoder);
    }

    @Override
    protected void releaseResources() {
        this.request = null;
        this.buf = null;
    }

    @Override
    protected HttpRequest buildResult(HttpContext context) {
        return this.request;
    }
}

