/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.nio.protocol;

import java.io.IOException;
import org.elasticsearch.client.http.HttpException;
import org.elasticsearch.client.http.HttpRequest;
import org.elasticsearch.client.http.annotation.Contract;
import org.elasticsearch.client.http.annotation.ThreadingBehavior;
import org.elasticsearch.client.http.nio.protocol.BasicAsyncRequestConsumer;
import org.elasticsearch.client.http.nio.protocol.HttpAsyncExchange;
import org.elasticsearch.client.http.nio.protocol.HttpAsyncRequestConsumer;
import org.elasticsearch.client.http.nio.protocol.HttpAsyncRequestHandler;
import org.elasticsearch.client.http.protocol.HttpContext;
import org.elasticsearch.client.http.protocol.HttpRequestHandler;
import org.elasticsearch.client.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class BasicAsyncRequestHandler
implements HttpAsyncRequestHandler<HttpRequest> {
    private final HttpRequestHandler handler;

    public BasicAsyncRequestHandler(HttpRequestHandler handler) {
        Args.notNull(handler, "Request handler");
        this.handler = handler;
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(HttpRequest request, HttpContext context) {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(HttpRequest request, HttpAsyncExchange httpexchange, HttpContext context) throws HttpException, IOException {
        this.handler.handle(request, httpexchange.getResponse(), context);
        httpexchange.submitResponse();
    }
}

