/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.nio.protocol;

import java.io.IOException;
import org.elasticsearch.client.http.HttpEntity;
import org.elasticsearch.client.http.HttpResponse;
import org.elasticsearch.client.http.nio.ContentEncoder;
import org.elasticsearch.client.http.nio.IOControl;
import org.elasticsearch.client.http.nio.entity.EntityAsyncContentProducer;
import org.elasticsearch.client.http.nio.entity.HttpAsyncContentProducer;
import org.elasticsearch.client.http.nio.protocol.HttpAsyncResponseProducer;
import org.elasticsearch.client.http.protocol.HttpContext;

class ErrorResponseProducer
implements HttpAsyncResponseProducer {
    private final HttpResponse response;
    private final HttpEntity entity;
    private final HttpAsyncContentProducer contentProducer;
    private final boolean keepAlive;

    ErrorResponseProducer(HttpResponse response, HttpEntity entity, boolean keepAlive) {
        this.response = response;
        this.entity = entity;
        this.contentProducer = entity instanceof HttpAsyncContentProducer ? (HttpAsyncContentProducer)((Object)entity) : new EntityAsyncContentProducer(entity);
        this.keepAlive = keepAlive;
    }

    @Override
    public HttpResponse generateResponse() {
        if (this.keepAlive) {
            this.response.addHeader("Connection", "Keep-Alive");
        } else {
            this.response.addHeader("Connection", "Close");
        }
        this.response.setEntity(this.entity);
        return this.response;
    }

    @Override
    public void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        this.contentProducer.produceContent(encoder, ioctrl);
    }

    @Override
    public void responseCompleted(HttpContext context) {
    }

    @Override
    public void failed(Exception ex) {
    }

    @Override
    public void close() throws IOException {
        this.contentProducer.close();
    }
}

