/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.nio.protocol;

import org.elasticsearch.client.http.HttpRequest;
import org.elasticsearch.client.http.annotation.Contract;
import org.elasticsearch.client.http.annotation.ThreadingBehavior;
import org.elasticsearch.client.http.nio.protocol.HttpAsyncRequestHandler;
import org.elasticsearch.client.http.nio.protocol.HttpAsyncRequestHandlerMapper;
import org.elasticsearch.client.http.protocol.UriPatternMatcher;
import org.elasticsearch.client.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class UriHttpAsyncRequestHandlerMapper
implements HttpAsyncRequestHandlerMapper {
    private final UriPatternMatcher<HttpAsyncRequestHandler<?>> matcher;

    protected UriHttpAsyncRequestHandlerMapper(UriPatternMatcher<HttpAsyncRequestHandler<?>> matcher) {
        this.matcher = Args.notNull(matcher, "Pattern matcher");
    }

    public UriHttpAsyncRequestHandlerMapper() {
        this(new UriPatternMatcher());
    }

    public void register(String pattern, HttpAsyncRequestHandler<?> handler) {
        this.matcher.register(pattern, handler);
    }

    public void unregister(String pattern) {
        this.matcher.unregister(pattern);
    }

    protected String getRequestPath(HttpRequest request) {
        String uriPath = request.getRequestLine().getUri();
        int index = uriPath.indexOf("?");
        if (index != -1) {
            uriPath = uriPath.substring(0, index);
        } else {
            index = uriPath.indexOf("#");
            if (index != -1) {
                uriPath = uriPath.substring(0, index);
            }
        }
        return uriPath;
    }

    @Override
    public HttpAsyncRequestHandler<?> lookup(HttpRequest request) {
        return this.matcher.lookup(this.getRequestPath(request));
    }
}

