/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.protocol;

import java.io.IOException;
import org.elasticsearch.client.http.HttpException;
import org.elasticsearch.client.http.HttpRequest;
import org.elasticsearch.client.http.HttpRequestInterceptor;
import org.elasticsearch.client.http.annotation.Contract;
import org.elasticsearch.client.http.annotation.ThreadingBehavior;
import org.elasticsearch.client.http.protocol.HttpContext;
import org.elasticsearch.client.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConnControl
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

