/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.http.protocol;

import java.io.IOException;
import org.elasticsearch.client.http.HttpEntityEnclosingRequest;
import org.elasticsearch.client.http.HttpException;
import org.elasticsearch.client.http.HttpRequest;
import org.elasticsearch.client.http.HttpRequestInterceptor;
import org.elasticsearch.client.http.annotation.Contract;
import org.elasticsearch.client.http.annotation.ThreadingBehavior;
import org.elasticsearch.client.http.protocol.HttpContext;
import org.elasticsearch.client.http.protocol.HttpDateGenerator;
import org.elasticsearch.client.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

