/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionClosedException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.client.AuthCache;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.client.methods.HttpAsyncMethods;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;
import org.elasticsearch.client.Cancellable;
import org.elasticsearch.client.DeadHostState;
import org.elasticsearch.client.HttpDeleteWithEntity;
import org.elasticsearch.client.HttpGetWithEntity;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.NodeSelector;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestLogger;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.WarningFailureException;
import org.elasticsearch.client.WarningsHandler;

public class RestClient
implements Closeable {
    private static final Log logger = LogFactory.getLog(RestClient.class);
    private final CloseableHttpAsyncClient client;
    final List<Header> defaultHeaders;
    private final String pathPrefix;
    private final AtomicInteger lastNodeIndex = new AtomicInteger(0);
    private final ConcurrentMap<HttpHost, DeadHostState> blacklist = new ConcurrentHashMap<HttpHost, DeadHostState>();
    private final FailureListener failureListener;
    private final NodeSelector nodeSelector;
    private volatile NodeTuple<List<Node>> nodeTuple;
    private final WarningsHandler warningsHandler;
    private final boolean compressionEnabled;
    private final boolean metaHeaderEnabled;

    RestClient(CloseableHttpAsyncClient client, Header[] defaultHeaders, List<Node> nodes, String pathPrefix, FailureListener failureListener, NodeSelector nodeSelector, boolean strictDeprecationMode, boolean compressionEnabled, boolean metaHeaderEnabled) {
        this.client = client;
        this.defaultHeaders = Collections.unmodifiableList(Arrays.asList(defaultHeaders));
        this.failureListener = failureListener;
        this.pathPrefix = pathPrefix;
        this.nodeSelector = nodeSelector;
        this.warningsHandler = strictDeprecationMode ? WarningsHandler.STRICT : WarningsHandler.PERMISSIVE;
        this.compressionEnabled = compressionEnabled;
        this.metaHeaderEnabled = metaHeaderEnabled;
        this.setNodes(nodes);
    }

    public static RestClientBuilder builder(String cloudId) {
        int port;
        String decoded;
        String[] decodedParts;
        if (cloudId.contains(":")) {
            if (cloudId.indexOf(":") == cloudId.length() - 1) {
                throw new IllegalStateException("cloudId " + cloudId + " must begin with a human readable identifier followed by a colon");
            }
            cloudId = cloudId.substring(cloudId.indexOf(":") + 1);
        }
        if ((decodedParts = (decoded = new String(Base64.getDecoder().decode(cloudId), StandardCharsets.UTF_8)).split("\\$")).length != 3) {
            throw new IllegalStateException("cloudId " + cloudId + " did not decode to a cluster identifier correctly");
        }
        String[] domainAndMaybePort = decodedParts[0].split(":", 2);
        String domain = domainAndMaybePort[0];
        if (domainAndMaybePort.length == 2) {
            try {
                port = Integer.parseInt(domainAndMaybePort[1]);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalStateException("cloudId " + cloudId + " does not contain a valid port number");
            }
        } else {
            port = 443;
        }
        String url = decodedParts[1] + "." + domain;
        return RestClient.builder(new HttpHost(url, port, "https"));
    }

    public static RestClientBuilder builder(Node ... nodes) {
        return new RestClientBuilder(nodes == null ? null : Arrays.asList(nodes));
    }

    public static RestClientBuilder builder(HttpHost ... hosts) {
        if (hosts == null || hosts.length == 0) {
            throw new IllegalArgumentException("hosts must not be null nor empty");
        }
        List<Node> nodes = Arrays.stream(hosts).map(Node::new).collect(Collectors.toList());
        return new RestClientBuilder(nodes);
    }

    public HttpAsyncClient getHttpClient() {
        return this.client;
    }

    public synchronized void setNodes(Collection<Node> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            throw new IllegalArgumentException("nodes must not be null or empty");
        }
        BasicAuthCache authCache = new BasicAuthCache();
        LinkedHashMap<HttpHost, Node> nodesByHost = new LinkedHashMap<HttpHost, Node>();
        for (Node node : nodes) {
            Objects.requireNonNull(node, "node cannot be null");
            nodesByHost.put(node.getHost(), node);
            authCache.put(node.getHost(), (AuthScheme)new BasicScheme());
        }
        this.nodeTuple = new NodeTuple(Collections.unmodifiableList(new ArrayList(nodesByHost.values())), (AuthCache)authCache);
        this.blacklist.clear();
    }

    public List<Node> getNodes() {
        return (List)this.nodeTuple.nodes;
    }

    public boolean isRunning() {
        return this.client.isRunning();
    }

    public Response performRequest(Request request) throws IOException {
        InternalRequest internalRequest = new InternalRequest(request);
        return this.performRequest(this.nextNodes(), internalRequest, null);
    }

    private Response performRequest(NodeTuple<Iterator<Node>> tuple, InternalRequest request, Exception previousException) throws IOException {
        HttpResponse httpResponse;
        RequestContext context = request.createContextForNextAttempt((Node)((Iterator)tuple.nodes).next(), tuple.authCache);
        try {
            httpResponse = (HttpResponse)this.client.execute(context.requestProducer, context.asyncResponseConsumer, (HttpContext)context.context, null).get();
        }
        catch (Exception e) {
            RequestLogger.logFailedRequest(logger, (HttpUriRequest)request.httpRequest, context.node, e);
            this.onFailure(context.node);
            Exception cause = RestClient.extractAndWrapCause(e);
            RestClient.addSuppressedException(previousException, cause);
            if (((Iterator)tuple.nodes).hasNext()) {
                return this.performRequest(tuple, request, cause);
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IllegalStateException("unexpected exception type: must be either RuntimeException or IOException", cause);
        }
        ResponseOrResponseException responseOrResponseException = this.convertResponse(request, context.node, httpResponse);
        if (responseOrResponseException.responseException == null) {
            return responseOrResponseException.response;
        }
        RestClient.addSuppressedException(previousException, responseOrResponseException.responseException);
        if (((Iterator)tuple.nodes).hasNext()) {
            return this.performRequest(tuple, request, responseOrResponseException.responseException);
        }
        throw responseOrResponseException.responseException;
    }

    private ResponseOrResponseException convertResponse(InternalRequest request, Node node, HttpResponse httpResponse) throws IOException {
        Header header;
        RequestLogger.logResponse(logger, (HttpUriRequest)request.httpRequest, node.getHost(), httpResponse);
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null && (header = entity.getContentEncoding()) != null && "gzip".equals(header.getValue())) {
            httpResponse.setEntity((HttpEntity)new GzipDecompressingEntity(entity));
            httpResponse.removeHeaders("Content-Encoding");
            httpResponse.removeHeaders("Content-Length");
        }
        Response response = new Response(request.httpRequest.getRequestLine(), node.getHost(), httpResponse);
        if (RestClient.isSuccessfulResponse(statusCode) || request.ignoreErrorCodes.contains(response.getStatusLine().getStatusCode())) {
            this.onResponse(node);
            if (request.warningsHandler.warningsShouldFailRequest(response.getWarnings())) {
                throw new WarningFailureException(response);
            }
            return new ResponseOrResponseException(response);
        }
        ResponseException responseException = new ResponseException(response);
        if (RestClient.isRetryStatus(statusCode)) {
            this.onFailure(node);
            return new ResponseOrResponseException(responseException);
        }
        this.onResponse(node);
        throw responseException;
    }

    public Cancellable performRequestAsync(Request request, ResponseListener responseListener) {
        try {
            FailureTrackingResponseListener failureTrackingResponseListener = new FailureTrackingResponseListener(responseListener);
            InternalRequest internalRequest = new InternalRequest(request);
            this.performRequestAsync(this.nextNodes(), internalRequest, failureTrackingResponseListener);
            return internalRequest.cancellable;
        }
        catch (Exception e) {
            responseListener.onFailure(e);
            return Cancellable.NO_OP;
        }
    }

    private void performRequestAsync(final NodeTuple<Iterator<Node>> tuple, final InternalRequest request, final FailureTrackingResponseListener listener) {
        request.cancellable.runIfNotCancelled(() -> {
            final RequestContext context = request.createContextForNextAttempt((Node)((Iterator)tuple.nodes).next(), tuple.authCache);
            this.client.execute(context.requestProducer, context.asyncResponseConsumer, (HttpContext)context.context, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse httpResponse) {
                    try {
                        ResponseOrResponseException responseOrResponseException = RestClient.this.convertResponse(request, context.node, httpResponse);
                        if (responseOrResponseException.responseException == null) {
                            listener.onSuccess(responseOrResponseException.response);
                        } else if (((Iterator)tuple.nodes).hasNext()) {
                            listener.trackFailure(responseOrResponseException.responseException);
                            RestClient.this.performRequestAsync(tuple, request, listener);
                        } else {
                            listener.onDefinitiveFailure(responseOrResponseException.responseException);
                        }
                    }
                    catch (Exception e) {
                        listener.onDefinitiveFailure(e);
                    }
                }

                public void failed(Exception failure) {
                    try {
                        RequestLogger.logFailedRequest(logger, (HttpUriRequest)request.httpRequest, context.node, failure);
                        RestClient.this.onFailure(context.node);
                        if (((Iterator)tuple.nodes).hasNext()) {
                            listener.trackFailure(failure);
                            RestClient.this.performRequestAsync(tuple, request, listener);
                        } else {
                            listener.onDefinitiveFailure(failure);
                        }
                    }
                    catch (Exception e) {
                        listener.onDefinitiveFailure(e);
                    }
                }

                public void cancelled() {
                    listener.onDefinitiveFailure(Cancellable.newCancellationException());
                }
            });
        });
    }

    private NodeTuple<Iterator<Node>> nextNodes() throws IOException {
        NodeTuple<List<Node>> tuple = this.nodeTuple;
        Iterable<Node> hosts = RestClient.selectNodes(tuple, this.blacklist, this.lastNodeIndex, this.nodeSelector);
        return new NodeTuple<Iterator<Node>>(hosts.iterator(), tuple.authCache);
    }

    static Iterable<Node> selectNodes(NodeTuple<List<Node>> nodeTuple, Map<HttpHost, DeadHostState> blacklist, AtomicInteger lastNodeIndex, NodeSelector nodeSelector) throws IOException {
        ArrayList<Node> livingNodes = new ArrayList<Node>(Math.max(0, ((List)nodeTuple.nodes).size() - blacklist.size()));
        ArrayList<DeadNode> deadNodes = new ArrayList<DeadNode>(blacklist.size());
        for (Node node : (List)nodeTuple.nodes) {
            DeadHostState deadness = blacklist.get(node.getHost());
            if (deadness == null || deadness.shallBeRetried()) {
                livingNodes.add(node);
                continue;
            }
            deadNodes.add(new DeadNode(node, deadness));
        }
        if (!livingNodes.isEmpty()) {
            ArrayList<Node> selectedLivingNodes = new ArrayList<Node>(livingNodes);
            nodeSelector.select(selectedLivingNodes);
            if (!selectedLivingNodes.isEmpty()) {
                Collections.rotate(selectedLivingNodes, lastNodeIndex.getAndIncrement());
                return selectedLivingNodes;
            }
        }
        if (!deadNodes.isEmpty()) {
            ArrayList selectedDeadNodes = new ArrayList(deadNodes);
            nodeSelector.select(() -> new DeadNodeIteratorAdapter(selectedDeadNodes.iterator()));
            if (!selectedDeadNodes.isEmpty()) {
                return Collections.singletonList(((DeadNode)Collections.min(selectedDeadNodes)).node);
            }
        }
        throw new IOException("NodeSelector [" + nodeSelector + "] rejected all nodes, living " + livingNodes + " and dead " + deadNodes);
    }

    private void onResponse(Node node) {
        DeadHostState removedHost = (DeadHostState)this.blacklist.remove(node.getHost());
        if (logger.isDebugEnabled() && removedHost != null) {
            logger.debug((Object)("removed [" + node + "] from blacklist"));
        }
    }

    private void onFailure(Node node) {
        block3: {
            DeadHostState previousDeadHostState;
            do {
                if ((previousDeadHostState = this.blacklist.putIfAbsent(node.getHost(), new DeadHostState(DeadHostState.DEFAULT_TIME_SUPPLIER))) != null) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("added [" + node + "] to blacklist"));
                }
                break block3;
            } while (!this.blacklist.replace(node.getHost(), previousDeadHostState, new DeadHostState(previousDeadHostState)));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("updated [" + node + "] already in blacklist"));
            }
        }
        this.failureListener.onFailure(node);
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    private static boolean isSuccessfulResponse(int statusCode) {
        return statusCode < 300;
    }

    private static boolean isRetryStatus(int statusCode) {
        switch (statusCode) {
            case 502: 
            case 503: 
            case 504: {
                return true;
            }
        }
        return false;
    }

    private static void addSuppressedException(Exception suppressedException, Exception currentException) {
        if (suppressedException != null) {
            currentException.addSuppressed(suppressedException);
        }
    }

    private static HttpRequestBase createHttpRequest(String method, URI uri, HttpEntity entity, boolean compressionEnabled) {
        switch (method.toUpperCase(Locale.ROOT)) {
            case "DELETE": {
                return RestClient.addRequestBody((HttpRequestBase)new HttpDeleteWithEntity(uri), entity, compressionEnabled);
            }
            case "GET": {
                return RestClient.addRequestBody((HttpRequestBase)new HttpGetWithEntity(uri), entity, compressionEnabled);
            }
            case "HEAD": {
                return RestClient.addRequestBody((HttpRequestBase)new HttpHead(uri), entity, compressionEnabled);
            }
            case "OPTIONS": {
                return RestClient.addRequestBody((HttpRequestBase)new HttpOptions(uri), entity, compressionEnabled);
            }
            case "PATCH": {
                return RestClient.addRequestBody((HttpRequestBase)new HttpPatch(uri), entity, compressionEnabled);
            }
            case "POST": {
                HttpPost httpPost = new HttpPost(uri);
                RestClient.addRequestBody((HttpRequestBase)httpPost, entity, compressionEnabled);
                return httpPost;
            }
            case "PUT": {
                return RestClient.addRequestBody((HttpRequestBase)new HttpPut(uri), entity, compressionEnabled);
            }
            case "TRACE": {
                return RestClient.addRequestBody((HttpRequestBase)new HttpTrace(uri), entity, compressionEnabled);
            }
        }
        throw new UnsupportedOperationException("http method not supported: " + method);
    }

    private static HttpRequestBase addRequestBody(HttpRequestBase httpRequest, HttpEntity entity, boolean compressionEnabled) {
        if (entity != null) {
            if (httpRequest instanceof HttpEntityEnclosingRequestBase) {
                if (compressionEnabled) {
                    entity = new ContentCompressingEntity((HttpEntity)entity);
                }
                ((HttpEntityEnclosingRequestBase)httpRequest).setEntity(entity);
            } else {
                throw new UnsupportedOperationException(httpRequest.getMethod() + " with body is not supported");
            }
        }
        return httpRequest;
    }

    static URI buildUri(String pathPrefix, String path, Map<String, String> params) {
        Objects.requireNonNull(path, "path must not be null");
        try {
            String fullPath = pathPrefix != null && !pathPrefix.isEmpty() ? (pathPrefix.endsWith("/") && path.startsWith("/") ? pathPrefix.substring(0, pathPrefix.length() - 1) + path : (pathPrefix.endsWith("/") || path.startsWith("/") ? pathPrefix + path : pathPrefix + "/" + path)) : path;
            URIBuilder uriBuilder = new URIBuilder(fullPath);
            for (Map.Entry<String, String> param : params.entrySet()) {
                uriBuilder.addParameter(param.getKey(), param.getValue());
            }
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private static Set<Integer> getIgnoreErrorCodes(String ignoreString, String requestMethod) {
        Set<Integer> ignoreErrorCodes;
        if (ignoreString == null) {
            ignoreErrorCodes = "HEAD".equals(requestMethod) ? Collections.singleton(404) : Collections.emptySet();
        } else {
            String[] ignoresArray = ignoreString.split(",");
            ignoreErrorCodes = new HashSet();
            if ("HEAD".equals(requestMethod)) {
                ignoreErrorCodes.add(404);
            }
            for (String ignoreCode : ignoresArray) {
                try {
                    ignoreErrorCodes.add(Integer.valueOf(ignoreCode));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("ignore value should be a number, found [" + ignoreString + "] instead", e);
                }
            }
        }
        return ignoreErrorCodes;
    }

    private static Exception extractAndWrapCause(Exception exception) {
        Object e;
        if (exception instanceof InterruptedException) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("thread waiting for the response was interrupted", exception);
        }
        if (exception instanceof ExecutionException) {
            Throwable t;
            ExecutionException executionException = (ExecutionException)exception;
            Throwable throwable = t = executionException.getCause() == null ? executionException : executionException.getCause();
            if (t instanceof Error) {
                throw (Error)t;
            }
            exception = t;
        }
        if (exception instanceof ConnectTimeoutException) {
            e = new ConnectTimeoutException(exception.getMessage());
            e.initCause((Throwable)exception);
            return e;
        }
        if (exception instanceof SocketTimeoutException) {
            e = new SocketTimeoutException(exception.getMessage());
            ((Throwable)e).initCause(exception);
            return e;
        }
        if (exception instanceof ConnectionClosedException) {
            e = new ConnectionClosedException(exception.getMessage());
            e.initCause((Throwable)exception);
            return e;
        }
        if (exception instanceof SSLHandshakeException) {
            e = new SSLHandshakeException(exception.getMessage());
            ((Throwable)e).initCause(exception);
            return e;
        }
        if (exception instanceof ConnectException) {
            e = new ConnectException(exception.getMessage());
            ((Throwable)e).initCause(exception);
            return e;
        }
        if (exception instanceof IOException) {
            return new IOException(exception.getMessage(), exception);
        }
        if (exception instanceof RuntimeException) {
            return new RuntimeException(exception.getMessage(), exception);
        }
        return new RuntimeException("error while performing request", exception);
    }

    static class NodeTuple<T> {
        final T nodes;
        final AuthCache authCache;

        NodeTuple(T nodes, AuthCache authCache) {
            this.nodes = nodes;
            this.authCache = authCache;
        }
    }

    private class InternalRequest {
        private final Request request;
        private final Set<Integer> ignoreErrorCodes;
        private final HttpRequestBase httpRequest;
        private final Cancellable cancellable;
        private final WarningsHandler warningsHandler;

        InternalRequest(Request request) {
            this.request = request;
            HashMap<String, String> params = new HashMap<String, String>(request.getParameters());
            params.putAll(request.getOptions().getParameters());
            String ignoreString = (String)params.remove("ignore");
            this.ignoreErrorCodes = RestClient.getIgnoreErrorCodes(ignoreString, request.getMethod());
            URI uri = RestClient.buildUri(RestClient.this.pathPrefix, request.getEndpoint(), params);
            this.httpRequest = RestClient.createHttpRequest(request.getMethod(), uri, request.getEntity(), RestClient.this.compressionEnabled);
            this.cancellable = Cancellable.fromRequest(this.httpRequest);
            this.setHeaders((HttpRequest)this.httpRequest, request.getOptions().getHeaders());
            this.setRequestConfig(this.httpRequest, request.getOptions().getRequestConfig());
            this.warningsHandler = request.getOptions().getWarningsHandler() == null ? RestClient.this.warningsHandler : request.getOptions().getWarningsHandler();
        }

        private void setHeaders(HttpRequest req, Collection<Header> requestHeaders) {
            HashSet<String> requestNames = new HashSet<String>(requestHeaders.size());
            for (Header requestHeader : requestHeaders) {
                req.addHeader(requestHeader);
                requestNames.add(requestHeader.getName());
            }
            for (Header defaultHeader : RestClient.this.defaultHeaders) {
                if (requestNames.contains(defaultHeader.getName())) continue;
                req.addHeader(defaultHeader);
            }
            if (RestClient.this.compressionEnabled) {
                req.addHeader("Accept-Encoding", "gzip");
            }
            if (RestClient.this.metaHeaderEnabled) {
                if (!req.containsHeader("X-Elastic-Client-Meta")) {
                    req.setHeader("X-Elastic-Client-Meta", RestClientBuilder.META_HEADER_VALUE);
                }
            } else {
                req.removeHeaders("X-Elastic-Client-Meta");
            }
        }

        private void setRequestConfig(HttpRequestBase requestBase, RequestConfig requestConfig) {
            if (requestConfig != null) {
                requestBase.setConfig(requestConfig);
            }
        }

        RequestContext createContextForNextAttempt(Node node, AuthCache authCache) {
            this.httpRequest.reset();
            return new RequestContext(this, node, authCache);
        }
    }

    static class FailureTrackingResponseListener {
        private final ResponseListener responseListener;
        private volatile Exception exception;

        FailureTrackingResponseListener(ResponseListener responseListener) {
            this.responseListener = responseListener;
        }

        void onSuccess(Response response) {
            this.responseListener.onSuccess(response);
        }

        void onDefinitiveFailure(Exception e) {
            this.trackFailure(e);
            this.responseListener.onFailure(this.exception);
        }

        void trackFailure(Exception e) {
            RestClient.addSuppressedException(this.exception, e);
            this.exception = e;
        }
    }

    private static class ResponseOrResponseException {
        private final Response response;
        private final ResponseException responseException;

        ResponseOrResponseException(Response response) {
            this.response = Objects.requireNonNull(response);
            this.responseException = null;
        }

        ResponseOrResponseException(ResponseException responseException) {
            this.responseException = Objects.requireNonNull(responseException);
            this.response = null;
        }
    }

    public static class FailureListener {
        public void onFailure(Node node) {
        }
    }

    private static class RequestContext {
        private final Node node;
        private final HttpAsyncRequestProducer requestProducer;
        private final HttpAsyncResponseConsumer<HttpResponse> asyncResponseConsumer;
        private final HttpClientContext context;

        RequestContext(InternalRequest request, Node node, AuthCache authCache) {
            this.node = node;
            this.requestProducer = HttpAsyncMethods.create((HttpHost)node.getHost(), (HttpRequest)request.httpRequest);
            this.asyncResponseConsumer = request.request.getOptions().getHttpAsyncResponseConsumerFactory().createHttpAsyncResponseConsumer();
            this.context = HttpClientContext.create();
            this.context.setAuthCache(authCache);
        }
    }

    private static class DeadNode
    implements Comparable<DeadNode> {
        final Node node;
        final DeadHostState deadness;

        DeadNode(Node node, DeadHostState deadness) {
            this.node = node;
            this.deadness = deadness;
        }

        public String toString() {
            return this.node.toString();
        }

        @Override
        public int compareTo(DeadNode rhs) {
            return this.deadness.compareTo(rhs.deadness);
        }
    }

    public static class ContentCompressingEntity
    extends GzipCompressingEntity {
        public ContentCompressingEntity(HttpEntity entity) {
            super(entity);
        }

        public InputStream getContent() throws IOException {
            ByteArrayInputOutputStream out = new ByteArrayInputOutputStream(1024);
            try (GZIPOutputStream gzipOut = new GZIPOutputStream(out);){
                this.wrappedEntity.writeTo((OutputStream)gzipOut);
            }
            return out.asInput();
        }
    }

    private static class DeadNodeIteratorAdapter
    implements Iterator<Node> {
        private final Iterator<DeadNode> itr;

        private DeadNodeIteratorAdapter(Iterator<DeadNode> itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public Node next() {
            return this.itr.next().node;
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    private static class ByteArrayInputOutputStream
    extends ByteArrayOutputStream {
        ByteArrayInputOutputStream(int size) {
            super(size);
        }

        public InputStream asInput() {
            return new ByteArrayInputStream(this.buf, 0, this.count);
        }
    }
}

