/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.RequestConverters;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.protocol.xpack.XPackInfoRequest;
import org.elasticsearch.protocol.xpack.XPackInfoResponse;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.protocol.xpack.XPackUsageResponse;

public final class XPackClient {
    private final RestHighLevelClient restHighLevelClient;

    XPackClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public XPackInfoResponse info(XPackInfoRequest request, RequestOptions options) throws IOException {
        return (XPackInfoResponse)((Object)this.restHighLevelClient.performRequestAndParseEntity(request, RequestConverters::xPackInfo, options, XPackInfoResponse::fromXContent, Collections.emptySet()));
    }

    public void infoAsync(XPackInfoRequest request, RequestOptions options, ActionListener<XPackInfoResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RequestConverters::xPackInfo, options, XPackInfoResponse::fromXContent, listener, Collections.emptySet());
    }

    public XPackUsageResponse usage(XPackUsageRequest request, RequestOptions options) throws IOException {
        return (XPackUsageResponse)this.restHighLevelClient.performRequestAndParseEntity(request, RequestConverters::xpackUsage, options, XPackUsageResponse::fromXContent, Collections.emptySet());
    }

    public void usageAsync(XPackUsageRequest request, RequestOptions options, ActionListener<XPackUsageResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RequestConverters::xpackUsage, options, XPackUsageResponse::fromXContent, listener, Collections.emptySet());
    }
}

