/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ccr;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.ccr.FollowConfig;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public final class PutFollowRequest
extends FollowConfig
implements Validatable,
ToXContentObject {
    static final ParseField REMOTE_CLUSTER_FIELD = new ParseField("remote_cluster", new String[0]);
    static final ParseField LEADER_INDEX_FIELD = new ParseField("leader_index", new String[0]);
    static final ParseField FOLLOWER_INDEX_FIELD = new ParseField("follower_index", new String[0]);
    private final String remoteCluster;
    private final String leaderIndex;
    private final String followerIndex;

    public PutFollowRequest(String remoteCluster, String leaderIndex, String followerIndex) {
        this.remoteCluster = Objects.requireNonNull(remoteCluster, "remoteCluster");
        this.leaderIndex = Objects.requireNonNull(leaderIndex, "leaderIndex");
        this.followerIndex = Objects.requireNonNull(followerIndex, "followerIndex");
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(REMOTE_CLUSTER_FIELD.getPreferredName(), this.remoteCluster);
        builder.field(LEADER_INDEX_FIELD.getPreferredName(), this.leaderIndex);
        builder.field(FOLLOWER_INDEX_FIELD.getPreferredName(), this.followerIndex);
        this.toXContentFragment(builder, params);
        builder.endObject();
        return builder;
    }

    public String getRemoteCluster() {
        return this.remoteCluster;
    }

    public String getLeaderIndex() {
        return this.leaderIndex;
    }

    public String getFollowerIndex() {
        return this.followerIndex;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PutFollowRequest that = (PutFollowRequest)o;
        return Objects.equals(this.remoteCluster, that.remoteCluster) && Objects.equals(this.leaderIndex, that.leaderIndex) && Objects.equals(this.followerIndex, that.followerIndex);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.remoteCluster, this.leaderIndex, this.followerIndex);
    }
}

