/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public final class InvalidateApiKeyResponse {
    private final List<String> invalidatedApiKeys;
    private final List<String> previouslyInvalidatedApiKeys;
    private final List<ElasticsearchException> errors;
    static ConstructingObjectParser<InvalidateApiKeyResponse, Void> PARSER = new ConstructingObjectParser("invalidate_api_key_response", args -> new InvalidateApiKeyResponse((List)args[0], (List)args[1], (List)args[3]));

    public InvalidateApiKeyResponse(List<String> invalidatedApiKeys, List<String> previouslyInvalidatedApiKeys, @Nullable List<ElasticsearchException> errors) {
        this.invalidatedApiKeys = Objects.requireNonNull(invalidatedApiKeys, "invalidated_api_keys must be provided");
        this.previouslyInvalidatedApiKeys = Objects.requireNonNull(previouslyInvalidatedApiKeys, "previously_invalidated_api_keys must be provided");
        this.errors = null != errors ? errors : Collections.emptyList();
    }

    public static InvalidateApiKeyResponse emptyResponse() {
        return new InvalidateApiKeyResponse(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public List<String> getInvalidatedApiKeys() {
        return this.invalidatedApiKeys;
    }

    public List<String> getPreviouslyInvalidatedApiKeys() {
        return this.previouslyInvalidatedApiKeys;
    }

    public List<ElasticsearchException> getErrors() {
        return this.errors;
    }

    public static InvalidateApiKeyResponse fromXContent(XContentParser parser) throws IOException {
        return (InvalidateApiKeyResponse)PARSER.parse(parser, null);
    }

    public int hashCode() {
        return Objects.hash(this.invalidatedApiKeys, this.previouslyInvalidatedApiKeys, this.errors);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InvalidateApiKeyResponse other = (InvalidateApiKeyResponse)obj;
        return Objects.equals(this.invalidatedApiKeys, other.invalidatedApiKeys) && Objects.equals(this.previouslyInvalidatedApiKeys, other.previouslyInvalidatedApiKeys) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "ApiKeysInvalidationResult [invalidatedApiKeys=" + this.invalidatedApiKeys + ", previouslyInvalidatedApiKeys=" + this.previouslyInvalidatedApiKeys + ", errors=" + this.errors + "]";
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), new ParseField("invalidated_api_keys", new String[0]));
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), new ParseField("previously_invalidated_api_keys", new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField("error_count", new String[0]));
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ElasticsearchException.fromXContent((XContentParser)p), new ParseField("error_details", new String[0]));
    }
}

