/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestConverters;
import org.elasticsearch.client.migration.DeprecationInfoRequest;
import org.elasticsearch.client.migration.IndexUpgradeInfoRequest;
import org.elasticsearch.client.migration.IndexUpgradeRequest;

final class MigrationRequestConverters {
    private MigrationRequestConverters() {
    }

    static Request getMigrationAssistance(IndexUpgradeInfoRequest indexUpgradeInfoRequest) {
        RequestConverters.EndpointBuilder endpointBuilder = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack", "migration", "assistance").addCommaSeparatedPathParts(indexUpgradeInfoRequest.indices());
        String endpoint = endpointBuilder.build();
        Request request = new Request("GET", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withIndicesOptions(indexUpgradeInfoRequest.indicesOptions());
        return request;
    }

    static Request migrate(IndexUpgradeRequest indexUpgradeRequest) {
        return MigrationRequestConverters.prepareMigrateRequest(indexUpgradeRequest, true);
    }

    static Request submitMigrateTask(IndexUpgradeRequest indexUpgradeRequest) {
        return MigrationRequestConverters.prepareMigrateRequest(indexUpgradeRequest, false);
    }

    static Request getDeprecationInfo(DeprecationInfoRequest deprecationInfoRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addCommaSeparatedPathParts(deprecationInfoRequest.getIndices()).addPathPartAsIs("_xpack", "migration", "deprecations").build();
        return new Request("GET", endpoint);
    }

    private static Request prepareMigrateRequest(IndexUpgradeRequest indexUpgradeRequest, boolean waitForCompletion) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_xpack", "migration", "upgrade").addPathPart(indexUpgradeRequest.index()).build();
        Request request = new Request("POST", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request).withWaitForCompletion(waitForCompletion);
        return request;
    }
}

