/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security.user.privileges;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.client.security.user.privileges.ApplicationResourcePrivileges;
import org.elasticsearch.client.security.user.privileges.GlobalPrivileges;
import org.elasticsearch.client.security.user.privileges.IndicesPrivileges;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public final class Role
implements ToXContentObject {
    public static final ParseField CLUSTER = new ParseField("cluster", new String[0]);
    public static final ParseField GLOBAL = new ParseField("global", new String[0]);
    public static final ParseField INDICES = new ParseField("indices", new String[0]);
    public static final ParseField APPLICATIONS = new ParseField("applications", new String[0]);
    public static final ParseField RUN_AS = new ParseField("run_as", new String[0]);
    public static final ParseField METADATA = new ParseField("metadata", new String[0]);
    private static final ConstructingObjectParser<Role, Void> PARSER = new ConstructingObjectParser("role_descriptor", false, constructorObjects -> {
        int i = 0;
        Collection clusterPrivileges = (Collection)constructorObjects[i++];
        GlobalPrivileges globalApplicationPrivileges = (GlobalPrivileges)constructorObjects[i++];
        Collection indicesPrivileges = (Collection)constructorObjects[i++];
        Collection applicationResourcePrivileges = (Collection)constructorObjects[i++];
        Collection runAsPrivilege = (Collection)constructorObjects[i++];
        Map metadata = (Map)constructorObjects[i];
        return new Role(clusterPrivileges, globalApplicationPrivileges, indicesPrivileges, applicationResourcePrivileges, runAsPrivilege, metadata);
    });
    private final Set<String> clusterPrivileges;
    @Nullable
    private final GlobalPrivileges globalApplicationPrivileges;
    private final Set<IndicesPrivileges> indicesPrivileges;
    private final Set<ApplicationResourcePrivileges> applicationResourcePrivileges;
    private final Set<String> runAsPrivilege;
    private final Map<String, Object> metadata;

    private Role(@Nullable Collection<String> clusterPrivileges, @Nullable GlobalPrivileges globalApplicationPrivileges, @Nullable Collection<IndicesPrivileges> indicesPrivileges, @Nullable Collection<ApplicationResourcePrivileges> applicationResourcePrivileges, @Nullable Collection<String> runAsPrivilege, @Nullable Map<String, Object> metadata) {
        this.clusterPrivileges = Collections.unmodifiableSet(clusterPrivileges != null ? new HashSet<String>(clusterPrivileges) : Collections.emptySet());
        this.globalApplicationPrivileges = globalApplicationPrivileges;
        this.indicesPrivileges = Collections.unmodifiableSet(indicesPrivileges != null ? new HashSet<IndicesPrivileges>(indicesPrivileges) : Collections.emptySet());
        this.applicationResourcePrivileges = Collections.unmodifiableSet(applicationResourcePrivileges != null ? new HashSet<ApplicationResourcePrivileges>(applicationResourcePrivileges) : Collections.emptySet());
        this.runAsPrivilege = Collections.unmodifiableSet(runAsPrivilege != null ? new HashSet<String>(runAsPrivilege) : Collections.emptySet());
        this.metadata = metadata != null ? Collections.unmodifiableMap(metadata) : Collections.emptyMap();
    }

    public Set<String> getClusterPrivileges() {
        return this.clusterPrivileges;
    }

    public GlobalPrivileges getGlobalApplicationPrivileges() {
        return this.globalApplicationPrivileges;
    }

    public Set<IndicesPrivileges> getIndicesPrivileges() {
        return this.indicesPrivileges;
    }

    public Set<ApplicationResourcePrivileges> getApplicationResourcePrivileges() {
        return this.applicationResourcePrivileges;
    }

    public Set<String> getRunAsPrivilege() {
        return this.runAsPrivilege;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Role that = (Role)o;
        return this.clusterPrivileges.equals(that.clusterPrivileges) && Objects.equals(this.globalApplicationPrivileges, that.globalApplicationPrivileges) && this.indicesPrivileges.equals(that.indicesPrivileges) && this.applicationResourcePrivileges.equals(that.applicationResourcePrivileges) && this.runAsPrivilege.equals(that.runAsPrivilege) && this.metadata.equals(that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.clusterPrivileges, this.globalApplicationPrivileges, this.indicesPrivileges, this.applicationResourcePrivileges, this.runAsPrivilege, this.metadata);
    }

    public String toString() {
        try {
            return XContentHelper.toXContent((ToXContent)this, (XContentType)XContentType.JSON, (boolean)true).utf8ToString();
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected", e);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (!this.clusterPrivileges.isEmpty()) {
            builder.field(CLUSTER.getPreferredName(), this.clusterPrivileges);
        }
        if (null != this.globalApplicationPrivileges) {
            builder.field(GLOBAL.getPreferredName(), (ToXContent)this.globalApplicationPrivileges);
        }
        if (!this.indicesPrivileges.isEmpty()) {
            builder.field(INDICES.getPreferredName(), this.indicesPrivileges);
        }
        if (!this.applicationResourcePrivileges.isEmpty()) {
            builder.field(APPLICATIONS.getPreferredName(), this.applicationResourcePrivileges);
        }
        if (!this.runAsPrivilege.isEmpty()) {
            builder.field(RUN_AS.getPreferredName(), this.runAsPrivilege);
        }
        if (!this.metadata.isEmpty()) {
            builder.field(METADATA.getPreferredName(), this.metadata);
        }
        return builder.endObject();
    }

    public static Role fromXContent(XContentParser parser) {
        return (Role)PARSER.apply(parser, null);
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), CLUSTER);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), GlobalPrivileges.PARSER, GLOBAL);
        PARSER.declareFieldArray(ConstructingObjectParser.optionalConstructorArg(), IndicesPrivileges.PARSER, INDICES, ObjectParser.ValueType.OBJECT_ARRAY);
        PARSER.declareFieldArray(ConstructingObjectParser.optionalConstructorArg(), ApplicationResourcePrivileges.PARSER, APPLICATIONS, ObjectParser.ValueType.OBJECT_ARRAY);
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), RUN_AS);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (parser, c) -> parser.map(), METADATA);
    }

    public static class IndexPrivilegeName {
        public static final String NONE = "none";
        public static final String ALL = "all";
        public static final String READ = "read";
        public static final String READ_CROSS = "read_cross_cluster";
        public static final String CREATE = "create";
        public static final String INDEX = "index";
        public static final String DELETE = "delete";
        public static final String WRITE = "write";
        public static final String MONITOR = "monitor";
        public static final String MANAGE = "manage";
        public static final String DELETE_INDEX = "delete_index";
        public static final String CREATE_INDEX = "create_index";
        public static final String VIEW_INDEX_METADATA = "view_index_metadata";
        public static final String MANAGE_FOLLOW_INDEX = "manage_follow_index";
    }

    public static class ClusterPrivilegeName {
        public static final String NONE = "none";
        public static final String ALL = "all";
        public static final String MONITOR = "monitor";
        public static final String MONITOR_ML = "monitor_ml";
        public static final String MONITOR_WATCHER = "monitor_watcher";
        public static final String MONITOR_ROLLUP = "monitor_rollup";
        public static final String MANAGE = "manage";
        public static final String MANAGE_ML = "manage_ml";
        public static final String MANAGE_WATCHER = "manage_watcher";
        public static final String MANAGE_ROLLUP = "manage_rollup";
        public static final String MANAGE_INDEX_TEMPLATES = "manage_index_templates";
        public static final String MANAGE_INGEST_PIPELINES = "manage_ingest_pipelines";
        public static final String TRANSPORT_CLIENT = "transport_client";
        public static final String MANAGE_SECURITY = "manage_security";
        public static final String MANAGE_SAML = "manage_saml";
        public static final String MANAGE_PIPELINE = "manage_pipeline";
        public static final String MANAGE_CCR = "manage_ccr";
        public static final String READ_CCR = "read_ccr";
    }

    public static final class Builder {
        @Nullable
        private Collection<String> clusterPrivileges = null;
        @Nullable
        private GlobalPrivileges globalApplicationPrivileges = null;
        @Nullable
        private Collection<IndicesPrivileges> indicesPrivileges = null;
        @Nullable
        private Collection<ApplicationResourcePrivileges> applicationResourcePrivileges = null;
        @Nullable
        private Collection<String> runAsPrivilege = null;
        @Nullable
        private Map<String, Object> metadata = null;

        private Builder() {
        }

        public Builder clusterPrivileges(String ... clusterPrivileges) {
            return this.clusterPrivileges(Arrays.asList(Objects.requireNonNull(clusterPrivileges, "Cluster privileges cannot be null. Pass an empty array instead.")));
        }

        public Builder clusterPrivileges(Collection<String> clusterPrivileges) {
            this.clusterPrivileges = Objects.requireNonNull(clusterPrivileges, "Cluster privileges cannot be null. Pass an empty collection instead.");
            return this;
        }

        public Builder glabalApplicationPrivileges(GlobalPrivileges globalApplicationPrivileges) {
            this.globalApplicationPrivileges = globalApplicationPrivileges;
            return this;
        }

        public Builder indicesPrivileges(IndicesPrivileges ... indicesPrivileges) {
            return this.indicesPrivileges(Arrays.asList(Objects.requireNonNull(indicesPrivileges, "Indices privileges cannot be null. Pass an empty array instead.")));
        }

        public Builder indicesPrivileges(Collection<IndicesPrivileges> indicesPrivileges) {
            this.indicesPrivileges = Objects.requireNonNull(indicesPrivileges, "Indices privileges cannot be null. Pass an empty collection instead.");
            return this;
        }

        public Builder applicationResourcePrivileges(ApplicationResourcePrivileges ... applicationResourcePrivileges) {
            return this.applicationResourcePrivileges(Arrays.asList(Objects.requireNonNull(applicationResourcePrivileges, "Application resource privileges cannot be null. Pass an empty array instead.")));
        }

        public Builder applicationResourcePrivileges(Collection<ApplicationResourcePrivileges> applicationResourcePrivileges) {
            this.applicationResourcePrivileges = Objects.requireNonNull(applicationResourcePrivileges, "Application resource privileges cannot be null. Pass an empty collection instead.");
            return this;
        }

        public Builder runAsPrivilege(String ... runAsPrivilege) {
            return this.runAsPrivilege(Arrays.asList(Objects.requireNonNull(runAsPrivilege, "Run as privilege cannot be null. Pass an empty array instead.")));
        }

        public Builder runAsPrivilege(Collection<String> runAsPrivilege) {
            this.runAsPrivilege = Objects.requireNonNull(runAsPrivilege, "Run as privilege cannot be null. Pass an empty collection instead.");
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = Objects.requireNonNull(metadata, "Metadata cannot be null. Pass an empty map instead.");
            return this;
        }

        public Role build() {
            return new Role(this.clusterPrivileges, this.globalApplicationPrivileges, this.indicesPrivileges, this.applicationResourcePrivileges, this.runAsPrivilege, this.metadata);
        }
    }
}

