/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.SecurityRequestConverters;
import org.elasticsearch.client.security.AuthenticateRequest;
import org.elasticsearch.client.security.AuthenticateResponse;
import org.elasticsearch.client.security.ChangePasswordRequest;
import org.elasticsearch.client.security.ClearRealmCacheRequest;
import org.elasticsearch.client.security.ClearRealmCacheResponse;
import org.elasticsearch.client.security.ClearRolesCacheRequest;
import org.elasticsearch.client.security.ClearRolesCacheResponse;
import org.elasticsearch.client.security.CreateTokenRequest;
import org.elasticsearch.client.security.CreateTokenResponse;
import org.elasticsearch.client.security.DeletePrivilegesRequest;
import org.elasticsearch.client.security.DeletePrivilegesResponse;
import org.elasticsearch.client.security.DeleteRoleMappingRequest;
import org.elasticsearch.client.security.DeleteRoleMappingResponse;
import org.elasticsearch.client.security.DeleteRoleRequest;
import org.elasticsearch.client.security.DeleteRoleResponse;
import org.elasticsearch.client.security.DeleteUserRequest;
import org.elasticsearch.client.security.DeleteUserResponse;
import org.elasticsearch.client.security.DisableUserRequest;
import org.elasticsearch.client.security.EmptyResponse;
import org.elasticsearch.client.security.EnableUserRequest;
import org.elasticsearch.client.security.GetPrivilegesRequest;
import org.elasticsearch.client.security.GetPrivilegesResponse;
import org.elasticsearch.client.security.GetRoleMappingsRequest;
import org.elasticsearch.client.security.GetRoleMappingsResponse;
import org.elasticsearch.client.security.GetRolesRequest;
import org.elasticsearch.client.security.GetRolesResponse;
import org.elasticsearch.client.security.GetSslCertificatesRequest;
import org.elasticsearch.client.security.GetSslCertificatesResponse;
import org.elasticsearch.client.security.GetUserPrivilegesRequest;
import org.elasticsearch.client.security.GetUserPrivilegesResponse;
import org.elasticsearch.client.security.GetUsersRequest;
import org.elasticsearch.client.security.GetUsersResponse;
import org.elasticsearch.client.security.HasPrivilegesRequest;
import org.elasticsearch.client.security.HasPrivilegesResponse;
import org.elasticsearch.client.security.InvalidateTokenRequest;
import org.elasticsearch.client.security.InvalidateTokenResponse;
import org.elasticsearch.client.security.PutPrivilegesRequest;
import org.elasticsearch.client.security.PutPrivilegesResponse;
import org.elasticsearch.client.security.PutRoleMappingRequest;
import org.elasticsearch.client.security.PutRoleMappingResponse;
import org.elasticsearch.client.security.PutRoleRequest;
import org.elasticsearch.client.security.PutRoleResponse;
import org.elasticsearch.client.security.PutUserRequest;
import org.elasticsearch.client.security.PutUserResponse;

public final class SecurityClient {
    private final RestHighLevelClient restHighLevelClient;

    SecurityClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public GetUsersResponse getUsers(GetUsersRequest request, RequestOptions options) throws IOException {
        return (GetUsersResponse)this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::getUsers, options, GetUsersResponse::fromXContent, Collections.emptySet());
    }

    public void getUsersAsync(GetUsersRequest request, RequestOptions options, ActionListener<GetUsersResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::getUsers, options, GetUsersResponse::fromXContent, listener, Collections.emptySet());
    }

    public PutUserResponse putUser(PutUserRequest request, RequestOptions options) throws IOException {
        return (PutUserResponse)this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::putUser, options, PutUserResponse::fromXContent, Collections.emptySet());
    }

    public void putUserAsync(PutUserRequest request, RequestOptions options, ActionListener<PutUserResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::putUser, options, PutUserResponse::fromXContent, listener, Collections.emptySet());
    }

    public DeleteUserResponse deleteUser(DeleteUserRequest request, RequestOptions options) throws IOException {
        return (DeleteUserResponse)this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::deleteUser, options, DeleteUserResponse::fromXContent, Collections.singleton(404));
    }

    public void deleteUserAsync(DeleteUserRequest request, RequestOptions options, ActionListener<DeleteUserResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::deleteUser, options, DeleteUserResponse::fromXContent, listener, Collections.singleton(404));
    }

    public PutRoleMappingResponse putRoleMapping(PutRoleMappingRequest request, RequestOptions options) throws IOException {
        return (PutRoleMappingResponse)this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::putRoleMapping, options, PutRoleMappingResponse::fromXContent, Collections.emptySet());
    }

    public void putRoleMappingAsync(PutRoleMappingRequest request, RequestOptions options, ActionListener<PutRoleMappingResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::putRoleMapping, options, PutRoleMappingResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetRoleMappingsResponse getRoleMappings(GetRoleMappingsRequest request, RequestOptions options) throws IOException {
        return (GetRoleMappingsResponse)this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::getRoleMappings, options, GetRoleMappingsResponse::fromXContent, Collections.emptySet());
    }

    public void getRoleMappingsAsync(GetRoleMappingsRequest request, RequestOptions options, ActionListener<GetRoleMappingsResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::getRoleMappings, options, GetRoleMappingsResponse::fromXContent, listener, Collections.emptySet());
    }

    public EmptyResponse enableUser(EnableUserRequest request, RequestOptions options) throws IOException {
        return (EmptyResponse)this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::enableUser, options, EmptyResponse::fromXContent, Collections.emptySet());
    }

    public void enableUserAsync(EnableUserRequest request, RequestOptions options, ActionListener<EmptyResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::enableUser, options, EmptyResponse::fromXContent, listener, Collections.emptySet());
    }

    public EmptyResponse disableUser(DisableUserRequest request, RequestOptions options) throws IOException {
        return (EmptyResponse)this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::disableUser, options, EmptyResponse::fromXContent, Collections.emptySet());
    }

    public void disableUserAsync(DisableUserRequest request, RequestOptions options, ActionListener<EmptyResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::disableUser, options, EmptyResponse::fromXContent, listener, Collections.emptySet());
    }

    public AuthenticateResponse authenticate(RequestOptions options) throws IOException {
        return (AuthenticateResponse)this.restHighLevelClient.performRequestAndParseEntity(AuthenticateRequest.INSTANCE, AuthenticateRequest::getRequest, options, AuthenticateResponse::fromXContent, Collections.emptySet());
    }

    public void authenticateAsync(RequestOptions options, ActionListener<AuthenticateResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(AuthenticateRequest.INSTANCE, AuthenticateRequest::getRequest, options, AuthenticateResponse::fromXContent, listener, Collections.emptySet());
    }

    public HasPrivilegesResponse hasPrivileges(HasPrivilegesRequest request, RequestOptions options) throws IOException {
        return (HasPrivilegesResponse)this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::hasPrivileges, options, HasPrivilegesResponse::fromXContent, Collections.emptySet());
    }

    public void hasPrivilegesAsync(HasPrivilegesRequest request, RequestOptions options, ActionListener<HasPrivilegesResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::hasPrivileges, options, HasPrivilegesResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetUserPrivilegesResponse getUserPrivileges(RequestOptions options) throws IOException {
        return (GetUserPrivilegesResponse)this.restHighLevelClient.performRequestAndParseEntity(GetUserPrivilegesRequest.INSTANCE, GetUserPrivilegesRequest::getRequest, options, GetUserPrivilegesResponse::fromXContent, Collections.emptySet());
    }

    public void getUserPrivilegesAsync(RequestOptions options, ActionListener<GetUserPrivilegesResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(GetUserPrivilegesRequest.INSTANCE, GetUserPrivilegesRequest::getRequest, options, GetUserPrivilegesResponse::fromXContent, listener, Collections.emptySet());
    }

    public ClearRealmCacheResponse clearRealmCache(ClearRealmCacheRequest request, RequestOptions options) throws IOException {
        return (ClearRealmCacheResponse)this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::clearRealmCache, options, ClearRealmCacheResponse::fromXContent, Collections.emptySet());
    }

    public void clearRealmCacheAsync(ClearRealmCacheRequest request, RequestOptions options, ActionListener<ClearRealmCacheResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::clearRealmCache, options, ClearRealmCacheResponse::fromXContent, listener, Collections.emptySet());
    }

    public ClearRolesCacheResponse clearRolesCache(ClearRolesCacheRequest request, RequestOptions options) throws IOException {
        return (ClearRolesCacheResponse)this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::clearRolesCache, options, ClearRolesCacheResponse::fromXContent, Collections.emptySet());
    }

    public void clearRolesCacheAsync(ClearRolesCacheRequest request, RequestOptions options, ActionListener<ClearRolesCacheResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::clearRolesCache, options, ClearRolesCacheResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetSslCertificatesResponse getSslCertificates(RequestOptions options) throws IOException {
        return (GetSslCertificatesResponse)this.restHighLevelClient.performRequestAndParseEntity(GetSslCertificatesRequest.INSTANCE, GetSslCertificatesRequest::getRequest, options, GetSslCertificatesResponse::fromXContent, Collections.emptySet());
    }

    public void getSslCertificatesAsync(RequestOptions options, ActionListener<GetSslCertificatesResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(GetSslCertificatesRequest.INSTANCE, GetSslCertificatesRequest::getRequest, options, GetSslCertificatesResponse::fromXContent, listener, Collections.emptySet());
    }

    public EmptyResponse changePassword(ChangePasswordRequest request, RequestOptions options) throws IOException {
        return (EmptyResponse)this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::changePassword, options, EmptyResponse::fromXContent, Collections.emptySet());
    }

    public void changePasswordAsync(ChangePasswordRequest request, RequestOptions options, ActionListener<EmptyResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::changePassword, options, EmptyResponse::fromXContent, listener, Collections.emptySet());
    }

    public DeleteRoleMappingResponse deleteRoleMapping(DeleteRoleMappingRequest request, RequestOptions options) throws IOException {
        return (DeleteRoleMappingResponse)this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::deleteRoleMapping, options, DeleteRoleMappingResponse::fromXContent, Collections.emptySet());
    }

    public void getRolesAsync(GetRolesRequest request, RequestOptions options, ActionListener<GetRolesResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::getRoles, options, GetRolesResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetRolesResponse getRoles(GetRolesRequest request, RequestOptions options) throws IOException {
        return (GetRolesResponse)this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::getRoles, options, GetRolesResponse::fromXContent, Collections.emptySet());
    }

    public void putRoleAsync(PutRoleRequest request, RequestOptions options, ActionListener<PutRoleResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::putRole, options, PutRoleResponse::fromXContent, listener, Collections.emptySet());
    }

    public PutRoleResponse putRole(PutRoleRequest request, RequestOptions options) throws IOException {
        return (PutRoleResponse)this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::putRole, options, PutRoleResponse::fromXContent, Collections.emptySet());
    }

    public void deleteRoleMappingAsync(DeleteRoleMappingRequest request, RequestOptions options, ActionListener<DeleteRoleMappingResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::deleteRoleMapping, options, DeleteRoleMappingResponse::fromXContent, listener, Collections.emptySet());
    }

    public DeleteRoleResponse deleteRole(DeleteRoleRequest request, RequestOptions options) throws IOException {
        return (DeleteRoleResponse)this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::deleteRole, options, DeleteRoleResponse::fromXContent, Collections.singleton(404));
    }

    public void deleteRoleAsync(DeleteRoleRequest request, RequestOptions options, ActionListener<DeleteRoleResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::deleteRole, options, DeleteRoleResponse::fromXContent, listener, Collections.singleton(404));
    }

    public CreateTokenResponse createToken(CreateTokenRequest request, RequestOptions options) throws IOException {
        return (CreateTokenResponse)this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::createToken, options, CreateTokenResponse::fromXContent, Collections.emptySet());
    }

    public void createTokenAsync(CreateTokenRequest request, RequestOptions options, ActionListener<CreateTokenResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::createToken, options, CreateTokenResponse::fromXContent, listener, Collections.emptySet());
    }

    public InvalidateTokenResponse invalidateToken(InvalidateTokenRequest request, RequestOptions options) throws IOException {
        return (InvalidateTokenResponse)this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::invalidateToken, options, InvalidateTokenResponse::fromXContent, Collections.emptySet());
    }

    public void invalidateTokenAsync(InvalidateTokenRequest request, RequestOptions options, ActionListener<InvalidateTokenResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::invalidateToken, options, InvalidateTokenResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetPrivilegesResponse getPrivileges(GetPrivilegesRequest request, RequestOptions options) throws IOException {
        return (GetPrivilegesResponse)this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::getPrivileges, options, GetPrivilegesResponse::fromXContent, Collections.emptySet());
    }

    public void getPrivilegesAsync(GetPrivilegesRequest request, RequestOptions options, ActionListener<GetPrivilegesResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::getPrivileges, options, GetPrivilegesResponse::fromXContent, listener, Collections.emptySet());
    }

    public PutPrivilegesResponse putPrivileges(PutPrivilegesRequest request, RequestOptions options) throws IOException {
        return (PutPrivilegesResponse)this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::putPrivileges, options, PutPrivilegesResponse::fromXContent, Collections.emptySet());
    }

    public void putPrivilegesAsync(PutPrivilegesRequest request, RequestOptions options, ActionListener<PutPrivilegesResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::putPrivileges, options, PutPrivilegesResponse::fromXContent, listener, Collections.emptySet());
    }

    public DeletePrivilegesResponse deletePrivileges(DeletePrivilegesRequest request, RequestOptions options) throws IOException {
        return (DeletePrivilegesResponse)this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::deletePrivileges, options, DeletePrivilegesResponse::fromXContent, Collections.singleton(404));
    }

    public void deletePrivilegesAsync(DeletePrivilegesRequest request, RequestOptions options, ActionListener<DeletePrivilegesResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::deletePrivileges, options, DeletePrivilegesResponse::fromXContent, listener, Collections.singleton(404));
    }
}

