/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public final class InvalidateTokenRequest
implements Validatable,
ToXContentObject {
    private final String accessToken;
    private final String refreshToken;

    InvalidateTokenRequest(@Nullable String accessToken, @Nullable String refreshToken) {
        if (Strings.isNullOrEmpty((String)accessToken)) {
            if (Strings.isNullOrEmpty((String)refreshToken)) {
                throw new IllegalArgumentException("Either access-token or refresh-token is required");
            }
        } else if (!Strings.isNullOrEmpty((String)refreshToken)) {
            throw new IllegalArgumentException("Cannot supply both access-token and refresh-token");
        }
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
    }

    public static InvalidateTokenRequest accessToken(String accessToken) {
        if (Strings.isNullOrEmpty((String)accessToken)) {
            throw new IllegalArgumentException("token is required");
        }
        return new InvalidateTokenRequest(accessToken, null);
    }

    public static InvalidateTokenRequest refreshToken(String refreshToken) {
        if (Strings.isNullOrEmpty((String)refreshToken)) {
            throw new IllegalArgumentException("refresh_token is required");
        }
        return new InvalidateTokenRequest(null, refreshToken);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.accessToken != null) {
            builder.field("token", this.accessToken);
        }
        if (this.refreshToken != null) {
            builder.field("refresh_token", this.refreshToken);
        }
        return builder.endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvalidateTokenRequest that = (InvalidateTokenRequest)o;
        return Objects.equals(this.accessToken, that.accessToken) && Objects.equals(this.refreshToken, that.refreshToken);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.refreshToken);
    }
}

