/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestConverters;
import org.elasticsearch.client.ccr.CcrStatsRequest;
import org.elasticsearch.client.ccr.DeleteAutoFollowPatternRequest;
import org.elasticsearch.client.ccr.FollowStatsRequest;
import org.elasticsearch.client.ccr.GetAutoFollowPatternRequest;
import org.elasticsearch.client.ccr.PauseFollowRequest;
import org.elasticsearch.client.ccr.PutAutoFollowPatternRequest;
import org.elasticsearch.client.ccr.PutFollowRequest;
import org.elasticsearch.client.ccr.ResumeFollowRequest;
import org.elasticsearch.client.ccr.UnfollowRequest;
import org.elasticsearch.common.xcontent.ToXContent;

final class CcrRequestConverters {
    CcrRequestConverters() {
    }

    static Request putFollow(PutFollowRequest putFollowRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPart(putFollowRequest.getFollowerIndex()).addPathPartAsIs("_ccr", "follow").build();
        Request request = new Request("PUT", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withWaitForActiveShards(putFollowRequest.waitForActiveShards());
        request.setEntity(RequestConverters.createEntity((ToXContent)putFollowRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request pauseFollow(PauseFollowRequest pauseFollowRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPart(pauseFollowRequest.getFollowerIndex()).addPathPartAsIs("_ccr", "pause_follow").build();
        return new Request("POST", endpoint);
    }

    static Request resumeFollow(ResumeFollowRequest resumeFollowRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPart(resumeFollowRequest.getFollowerIndex()).addPathPartAsIs("_ccr", "resume_follow").build();
        Request request = new Request("POST", endpoint);
        request.setEntity(RequestConverters.createEntity((ToXContent)resumeFollowRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request unfollow(UnfollowRequest unfollowRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPart(unfollowRequest.getFollowerIndex()).addPathPartAsIs("_ccr", "unfollow").build();
        return new Request("POST", endpoint);
    }

    static Request putAutoFollowPattern(PutAutoFollowPatternRequest putAutoFollowPatternRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_ccr", "auto_follow").addPathPart(putAutoFollowPatternRequest.getName()).build();
        Request request = new Request("PUT", endpoint);
        request.setEntity(RequestConverters.createEntity((ToXContent)putAutoFollowPatternRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request deleteAutoFollowPattern(DeleteAutoFollowPatternRequest deleteAutoFollowPatternRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_ccr", "auto_follow").addPathPart(deleteAutoFollowPatternRequest.getName()).build();
        return new Request("DELETE", endpoint);
    }

    static Request getAutoFollowPattern(GetAutoFollowPatternRequest getAutoFollowPatternRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_ccr", "auto_follow").addPathPart(getAutoFollowPatternRequest.getName()).build();
        return new Request("GET", endpoint);
    }

    static Request getCcrStats(CcrStatsRequest ccrStatsRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_ccr", "stats").build();
        return new Request("GET", endpoint);
    }

    static Request getFollowStats(FollowStatsRequest followStatsRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPart(followStatsRequest.getFollowerIndex()).addPathPartAsIs("_ccr", "stats").build();
        return new Request("GET", endpoint);
    }
}

