/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.indexlifecycle;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.indexlifecycle.LifecycleAction;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class RolloverAction
implements LifecycleAction,
ToXContentObject {
    public static final String NAME = "rollover";
    private static final ParseField MAX_SIZE_FIELD = new ParseField("max_size", new String[0]);
    private static final ParseField MAX_PRIMARY_SHARD_SIZE_FIELD = new ParseField("max_primary_shard_size", new String[0]);
    private static final ParseField MAX_AGE_FIELD = new ParseField("max_age", new String[0]);
    private static final ParseField MAX_DOCS_FIELD = new ParseField("max_docs", new String[0]);
    private static final ConstructingObjectParser<RolloverAction, Void> PARSER = new ConstructingObjectParser("rollover", true, a -> new RolloverAction((ByteSizeValue)a[0], (ByteSizeValue)a[1], (TimeValue)a[2], (Long)a[3]));
    private final ByteSizeValue maxSize;
    private final ByteSizeValue maxPrimaryShardSize;
    private final TimeValue maxAge;
    private final Long maxDocs;

    public static RolloverAction parse(XContentParser parser) {
        return (RolloverAction)PARSER.apply(parser, null);
    }

    public RolloverAction(ByteSizeValue maxSize, ByteSizeValue maxPrimaryShardSize, TimeValue maxAge, Long maxDocs) {
        if (maxSize == null && maxPrimaryShardSize == null && maxAge == null && maxDocs == null) {
            throw new IllegalArgumentException("At least one rollover condition must be set.");
        }
        this.maxSize = maxSize;
        this.maxPrimaryShardSize = maxPrimaryShardSize;
        this.maxAge = maxAge;
        this.maxDocs = maxDocs;
    }

    public ByteSizeValue getMaxSize() {
        return this.maxSize;
    }

    public ByteSizeValue getMaxPrimaryShardSize() {
        return this.maxPrimaryShardSize;
    }

    public TimeValue getMaxAge() {
        return this.maxAge;
    }

    public Long getMaxDocs() {
        return this.maxDocs;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.maxSize != null) {
            builder.field(MAX_SIZE_FIELD.getPreferredName(), this.maxSize.getStringRep());
        }
        if (this.maxPrimaryShardSize != null) {
            builder.field(MAX_PRIMARY_SHARD_SIZE_FIELD.getPreferredName(), this.maxPrimaryShardSize.getStringRep());
        }
        if (this.maxAge != null) {
            builder.field(MAX_AGE_FIELD.getPreferredName(), this.maxAge.getStringRep());
        }
        if (this.maxDocs != null) {
            builder.field(MAX_DOCS_FIELD.getPreferredName(), this.maxDocs);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.maxSize, this.maxPrimaryShardSize, this.maxAge, this.maxDocs);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        RolloverAction other = (RolloverAction)obj;
        return Objects.equals(this.maxSize, other.maxSize) && Objects.equals(this.maxPrimaryShardSize, other.maxPrimaryShardSize) && Objects.equals(this.maxAge, other.maxAge) && Objects.equals(this.maxDocs, other.maxDocs);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)MAX_SIZE_FIELD.getPreferredName()), MAX_SIZE_FIELD, ObjectParser.ValueType.VALUE);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)MAX_PRIMARY_SHARD_SIZE_FIELD.getPreferredName()), MAX_PRIMARY_SHARD_SIZE_FIELD, ObjectParser.ValueType.VALUE);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TimeValue.parseTimeValue((String)p.text(), (String)MAX_AGE_FIELD.getPreferredName()), MAX_AGE_FIELD, ObjectParser.ValueType.VALUE);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), MAX_DOCS_FIELD);
    }
}

