/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security.support.expressiondsl.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.client.security.support.expressiondsl.RoleMapperExpression;
import org.elasticsearch.client.security.support.expressiondsl.expressions.AllRoleMapperExpression;
import org.elasticsearch.client.security.support.expressiondsl.expressions.AnyRoleMapperExpression;
import org.elasticsearch.client.security.support.expressiondsl.expressions.CompositeType;
import org.elasticsearch.client.security.support.expressiondsl.expressions.ExceptRoleMapperExpression;
import org.elasticsearch.client.security.support.expressiondsl.fields.FieldRoleMapperExpression;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.CheckedFunction;

public final class RoleMapperExpressionParser {
    public static final ParseField FIELD = new ParseField("field", new String[0]);

    public static RoleMapperExpression fromXContent(XContentParser parser) throws IOException {
        return new RoleMapperExpressionParser().parse("rules", parser);
    }

    public static RoleMapperExpression parseObject(XContentParser parser, String id) throws IOException {
        return new RoleMapperExpressionParser().parse(id, parser);
    }

    public RoleMapperExpression parse(String name, XContentParser parser) throws IOException {
        return this.parseRulesObject(name, parser);
    }

    private RoleMapperExpression parseRulesObject(String objectName, XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken() == null ? parser.nextToken() : parser.currentToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("failed to parse rules expression. expected [{}] to be an object but found [{}] instead", new Object[]{objectName, token});
        }
        String fieldName = this.fieldName(objectName, parser);
        RoleMapperExpression expr = this.parseExpression(parser, fieldName, objectName);
        if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            throw new ElasticsearchParseException("failed to parse rules expression. object [{}] contains multiple fields", new Object[]{objectName});
        }
        return expr;
    }

    private RoleMapperExpression parseExpression(XContentParser parser, String field, String objectName) throws IOException {
        if (CompositeType.ANY.getParseField().match(field, parser.getDeprecationHandler())) {
            AnyRoleMapperExpression.Builder builder = AnyRoleMapperExpression.builder();
            this.parseExpressionArray(CompositeType.ANY.getParseField(), parser).forEach(builder::addExpression);
            return builder.build();
        }
        if (CompositeType.ALL.getParseField().match(field, parser.getDeprecationHandler())) {
            AllRoleMapperExpression.Builder builder = AllRoleMapperExpression.builder();
            this.parseExpressionArray(CompositeType.ALL.getParseField(), parser).forEach(builder::addExpression);
            return builder.build();
        }
        if (FIELD.match(field, parser.getDeprecationHandler())) {
            return this.parseFieldExpression(parser);
        }
        if (CompositeType.EXCEPT.getParseField().match(field, parser.getDeprecationHandler())) {
            return this.parseExceptExpression(parser);
        }
        throw new ElasticsearchParseException("failed to parse rules expression. field [{}] is not recognised in object [{}]", new Object[]{field, objectName});
    }

    private RoleMapperExpression parseFieldExpression(XContentParser parser) throws IOException {
        this.checkStartObject(parser);
        String fieldName = this.fieldName(FIELD.getPreferredName(), parser);
        List<Object> values = parser.nextToken() == XContentParser.Token.START_ARRAY ? this.parseArray(FIELD, parser, this::parseFieldValue) : Collections.singletonList(this.parseFieldValue(parser));
        if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            throw new ElasticsearchParseException("failed to parse rules expression. object [{}] contains multiple fields", new Object[]{FIELD.getPreferredName()});
        }
        return FieldRoleMapperExpression.ofKeyValues(fieldName, values.toArray());
    }

    private RoleMapperExpression parseExceptExpression(XContentParser parser) throws IOException {
        this.checkStartObject(parser);
        return new ExceptRoleMapperExpression(this.parseRulesObject(CompositeType.EXCEPT.getName(), parser));
    }

    private void checkStartObject(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("failed to parse rules expression. expected an object but found [{}] instead", new Object[]{token});
        }
    }

    private String fieldName(String objectName, XContentParser parser) throws IOException {
        if (parser.nextToken() != XContentParser.Token.FIELD_NAME) {
            throw new ElasticsearchParseException("failed to parse rules expression. object [{}] does not contain any fields", new Object[]{objectName});
        }
        String parsedFieldName = parser.currentName();
        return parsedFieldName;
    }

    private List<RoleMapperExpression> parseExpressionArray(ParseField field, XContentParser parser) throws IOException {
        parser.nextToken();
        return this.parseArray(field, parser, p -> this.parseRulesObject(field.getPreferredName(), (XContentParser)p));
    }

    private <T> List<T> parseArray(ParseField field, XContentParser parser, CheckedFunction<XContentParser, T, IOException> elementParser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            ArrayList<Object> list = new ArrayList<Object>();
            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                list.add(elementParser.apply((Object)parser));
            }
            return list;
        }
        throw new ElasticsearchParseException("failed to parse rules expression. field [{}] requires an array", new Object[]{field});
    }

    private Object parseFieldValue(XContentParser parser) throws IOException {
        switch (parser.currentToken()) {
            case VALUE_STRING: {
                return parser.text();
            }
            case VALUE_BOOLEAN: {
                return parser.booleanValue();
            }
            case VALUE_NUMBER: {
                return parser.longValue();
            }
            case VALUE_NULL: {
                return null;
            }
        }
        throw new ElasticsearchParseException("failed to parse rules expression. expected a field value but found [{}] instead", new Object[]{parser.currentToken()});
    }
}

