/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.analytics;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.client.analytics.InferencePipelineAggregationBuilder;
import org.elasticsearch.client.ml.inference.results.FeatureImportance;
import org.elasticsearch.client.ml.inference.results.TopClassEntry;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParseException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.ParsedAggregation;

public class ParsedInference
extends ParsedAggregation {
    private static final ConstructingObjectParser<ParsedInference, Void> PARSER = new ConstructingObjectParser(ParsedInference.class.getSimpleName(), true, args -> new ParsedInference(args[0], (List)args[1], (List)args[2], (String)args[3]));
    public static final ParseField FEATURE_IMPORTANCE = new ParseField("feature_importance", new String[0]);
    public static final ParseField WARNING = new ParseField("warning", new String[0]);
    public static final ParseField TOP_CLASSES = new ParseField("top_classes", new String[0]);
    private final Object value;
    private final List<FeatureImportance> featureImportance;
    private final List<TopClassEntry> topClasses;
    private final String warning;

    public static ParsedInference fromXContent(XContentParser parser, String name) {
        ParsedInference parsed = (ParsedInference)((Object)PARSER.apply(parser, null));
        parsed.setName(name);
        return parsed;
    }

    ParsedInference(Object value, List<FeatureImportance> featureImportance, List<TopClassEntry> topClasses, String warning) {
        this.value = value;
        this.warning = warning;
        this.featureImportance = featureImportance;
        this.topClasses = topClasses;
    }

    public Object getValue() {
        return this.value;
    }

    public List<FeatureImportance> getFeatureImportance() {
        return this.featureImportance;
    }

    public List<TopClassEntry> getTopClasses() {
        return this.topClasses;
    }

    public String getWarning() {
        return this.warning;
    }

    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.warning != null) {
            builder.field(WARNING.getPreferredName(), this.warning);
        } else {
            builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), this.value);
            if (this.topClasses != null && this.topClasses.size() > 0) {
                builder.field(TOP_CLASSES.getPreferredName(), this.topClasses);
            }
            if (this.featureImportance != null && this.featureImportance.size() > 0) {
                builder.field(FEATURE_IMPORTANCE.getPreferredName(), this.featureImportance);
            }
        }
        return builder;
    }

    public String getType() {
        return InferencePipelineAggregationBuilder.NAME;
    }

    static {
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, n) -> {
            Object o;
            XContentParser.Token token = p.currentToken();
            if (token == XContentParser.Token.VALUE_STRING) {
                o = p.text();
            } else if (token == XContentParser.Token.VALUE_BOOLEAN) {
                o = p.booleanValue();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                o = p.doubleValue();
            } else {
                throw new XContentParseException(p.getTokenLocation(), "[" + ParsedInference.class.getSimpleName() + "] failed to parse field [" + Aggregation.CommonFields.VALUE + "] value [" + token + "] is not a string, boolean or number");
            }
            return o;
        }, Aggregation.CommonFields.VALUE, ObjectParser.ValueType.VALUE);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> FeatureImportance.fromXContent(p), FEATURE_IMPORTANCE);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TopClassEntry.fromXContent(p), TOP_CLASSES);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), WARNING);
        ParsedInference.declareAggregationFields(PARSER);
    }
}

