/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.job.config;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Nullable;

public class AnalysisLimits
implements ToXContentObject {
    public static final ParseField MODEL_MEMORY_LIMIT = new ParseField("model_memory_limit", new String[0]);
    public static final ParseField CATEGORIZATION_EXAMPLES_LIMIT = new ParseField("categorization_examples_limit", new String[0]);
    public static final ConstructingObjectParser<AnalysisLimits, Void> PARSER = new ConstructingObjectParser("analysis_limits", true, a -> new AnalysisLimits((Long)a[0], (Long)a[1]));
    private final Long modelMemoryLimit;
    private final Long categorizationExamplesLimit;

    public AnalysisLimits(Long categorizationExamplesLimit) {
        this(null, categorizationExamplesLimit);
    }

    public AnalysisLimits(Long modelMemoryLimit, Long categorizationExamplesLimit) {
        this.modelMemoryLimit = modelMemoryLimit;
        this.categorizationExamplesLimit = categorizationExamplesLimit;
    }

    @Nullable
    public Long getModelMemoryLimit() {
        return this.modelMemoryLimit;
    }

    @Nullable
    public Long getCategorizationExamplesLimit() {
        return this.categorizationExamplesLimit;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.modelMemoryLimit != null) {
            builder.field(MODEL_MEMORY_LIMIT.getPreferredName(), this.modelMemoryLimit + "mb");
        }
        if (this.categorizationExamplesLimit != null) {
            builder.field(CATEGORIZATION_EXAMPLES_LIMIT.getPreferredName(), this.categorizationExamplesLimit);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnalysisLimits)) {
            return false;
        }
        AnalysisLimits that = (AnalysisLimits)other;
        return Objects.equals(this.modelMemoryLimit, that.modelMemoryLimit) && Objects.equals(this.categorizationExamplesLimit, that.categorizationExamplesLimit);
    }

    public int hashCode() {
        return Objects.hash(this.modelMemoryLimit, this.categorizationExamplesLimit);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)MODEL_MEMORY_LIMIT.getPreferredName()).getMb();
            }
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return p.longValue();
            }
            throw new IllegalArgumentException("Unsupported token [" + p.currentToken() + "]");
        }, MODEL_MEMORY_LIMIT, ObjectParser.ValueType.VALUE);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), CATEGORIZATION_EXAMPLES_LIMIT);
    }
}

