/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.client.security.support.ServiceTokenInfo;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.List;

public final class GetServiceAccountCredentialsResponse {
    private final String principal;
    private final String nodeName;
    private final java.util.List<ServiceTokenInfo> serviceTokenInfos;
    static ConstructingObjectParser<GetServiceAccountCredentialsResponse, Void> PARSER = new ConstructingObjectParser("get_service_account_credentials_response", args -> {
        java.util.List<ServiceTokenInfo> tokenInfos = Stream.concat(((Map)args[3]).keySet().stream().map(name -> new ServiceTokenInfo((String)name, "index")), ((Map)args[4]).keySet().stream().map(name -> new ServiceTokenInfo((String)name, "file"))).collect(Collectors.toList());
        assert (tokenInfos.size() == ((Integer)args[2]).intValue()) : "number of tokens do not match";
        return new GetServiceAccountCredentialsResponse((String)args[0], (String)args[1], tokenInfos);
    });

    public GetServiceAccountCredentialsResponse(String principal, String nodeName, java.util.List<ServiceTokenInfo> serviceTokenInfos) {
        this.principal = Objects.requireNonNull(principal, "principal is required");
        this.nodeName = Objects.requireNonNull(nodeName, "nodeName is required");
        this.serviceTokenInfos = List.copyOf((Collection)Objects.requireNonNull(serviceTokenInfos, "service token infos are required)"));
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public java.util.List<ServiceTokenInfo> getServiceTokenInfos() {
        return this.serviceTokenInfos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetServiceAccountCredentialsResponse that = (GetServiceAccountCredentialsResponse)o;
        return this.principal.equals(that.principal) && this.nodeName.equals(that.nodeName) && this.serviceTokenInfos.equals(that.serviceTokenInfos);
    }

    public int hashCode() {
        return Objects.hash(this.principal, this.nodeName, this.serviceTokenInfos);
    }

    public static GetServiceAccountCredentialsResponse fromXContent(XContentParser parser) throws IOException {
        return (GetServiceAccountCredentialsResponse)PARSER.parse(parser, null);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("service_account", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("node_name", new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField("count", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), new ParseField("tokens", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), new ParseField("file_tokens", new String[0]));
    }
}

