/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;

public final class CreateServiceAccountTokenResponse {
    private final String name;
    private final SecureString value;
    static final ConstructingObjectParser<Token, Void> TOKEN_PARSER = new ConstructingObjectParser("create_service_token_response_token", args -> new Token((String)args[0], (String)args[1]));
    static final ConstructingObjectParser<CreateServiceAccountTokenResponse, Void> PARSER = new ConstructingObjectParser("create_service_token_response", args -> {
        if (!((Boolean)args[0]).booleanValue()) {
            throw new IllegalStateException("The create field should always be true");
        }
        Token token = (Token)args[1];
        return new CreateServiceAccountTokenResponse(token.name, new SecureString(token.value.toCharArray()));
    });

    public CreateServiceAccountTokenResponse(String name, SecureString value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public SecureString getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateServiceAccountTokenResponse that = (CreateServiceAccountTokenResponse)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public static CreateServiceAccountTokenResponse fromXContent(XContentParser parser) throws IOException {
        return (CreateServiceAccountTokenResponse)PARSER.parse(parser, null);
    }

    static {
        TOKEN_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
        TOKEN_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("value", new String[0]));
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField("created", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), TOKEN_PARSER, new ParseField("token", new String[0]));
    }

    private static class Token {
        private final String name;
        private final String value;

        Token(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

