/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.security.support.ServiceAccountInfo;
import org.elasticsearch.client.security.user.privileges.Role;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Tuple;

public final class GetServiceAccountsResponse {
    private final List<ServiceAccountInfo> serviceAccountInfos;

    public GetServiceAccountsResponse(List<ServiceAccountInfo> serviceAccountInfos) {
        this.serviceAccountInfos = serviceAccountInfos;
    }

    public List<ServiceAccountInfo> getServiceAccountInfos() {
        return this.serviceAccountInfos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetServiceAccountsResponse that = (GetServiceAccountsResponse)o;
        return this.serviceAccountInfos.equals(that.serviceAccountInfos);
    }

    public int hashCode() {
        return Objects.hash(this.serviceAccountInfos);
    }

    public static GetServiceAccountsResponse fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        ArrayList<ServiceAccountInfo> serviceAccountInfos = new ArrayList<ServiceAccountInfo>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)parser);
            String principal = parser.currentName();
            Role role = GetServiceAccountsResponse.parseRoleDescriptor(parser);
            serviceAccountInfos.add(new ServiceAccountInfo(principal, role));
        }
        return new GetServiceAccountsResponse(serviceAccountInfos);
    }

    private static Role parseRoleDescriptor(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        XContentParserUtils.ensureFieldName((XContentParser)parser, (XContentParser.Token)parser.nextToken(), (String)"role_descriptor");
        Role role = (Role)((Tuple)Role.PARSER.parse(parser, (Object)parser.currentName())).v1();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        return role;
    }
}

