/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.eql;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.lookup.SourceLookup;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ContextParser;
import org.elasticsearch.xcontent.InstantiatingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class EqlSearchResponse {
    private final Hits hits;
    private final long tookInMillis;
    private final boolean isTimeout;
    private final String asyncExecutionId;
    private final boolean isRunning;
    private final boolean isPartial;
    private static final ParseField TOOK = new ParseField("took", new String[0]);
    private static final ParseField TIMED_OUT = new ParseField("timed_out", new String[0]);
    private static final ParseField HITS = new ParseField("hits", new String[0]);
    private static final ParseField ID = new ParseField("id", new String[0]);
    private static final ParseField IS_RUNNING = new ParseField("is_running", new String[0]);
    private static final ParseField IS_PARTIAL = new ParseField("is_partial", new String[0]);
    private static final InstantiatingObjectParser<EqlSearchResponse, Void> PARSER;

    public EqlSearchResponse(Hits hits, long tookInMillis, boolean isTimeout, String asyncExecutionId, boolean isRunning, boolean isPartial) {
        this.hits = hits == null ? Hits.EMPTY : hits;
        this.tookInMillis = tookInMillis;
        this.isTimeout = isTimeout;
        this.asyncExecutionId = asyncExecutionId;
        this.isRunning = isRunning;
        this.isPartial = isPartial;
    }

    public static EqlSearchResponse fromXContent(XContentParser parser) {
        return (EqlSearchResponse)PARSER.apply(parser, null);
    }

    public long took() {
        return this.tookInMillis;
    }

    public boolean isTimeout() {
        return this.isTimeout;
    }

    public Hits hits() {
        return this.hits;
    }

    public String id() {
        return this.asyncExecutionId;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean isPartial() {
        return this.isPartial;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EqlSearchResponse that = (EqlSearchResponse)o;
        return Objects.equals(this.hits, that.hits) && Objects.equals(this.tookInMillis, that.tookInMillis) && Objects.equals(this.isTimeout, that.isTimeout);
    }

    public int hashCode() {
        return Objects.hash(this.hits, this.tookInMillis, this.isTimeout);
    }

    static {
        InstantiatingObjectParser.Builder parser = InstantiatingObjectParser.builder((String)"eql/search_response", (boolean)true, EqlSearchResponse.class);
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> Hits.fromXContent(p), HITS);
        parser.declareLong(ConstructingObjectParser.constructorArg(), TOOK);
        parser.declareBoolean(ConstructingObjectParser.constructorArg(), TIMED_OUT);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), ID);
        parser.declareBoolean(ConstructingObjectParser.constructorArg(), IS_RUNNING);
        parser.declareBoolean(ConstructingObjectParser.constructorArg(), IS_PARTIAL);
        PARSER = parser.build();
    }

    public static class Hits {
        public static final Hits EMPTY = new Hits(null, null, null);
        private final List<Event> events;
        private final List<Sequence> sequences;
        private final TotalHits totalHits;
        private static final ConstructingObjectParser<Hits, Void> PARSER = new ConstructingObjectParser("eql/search_response_hits", true, args -> {
            int i = 0;
            List events = (List)args[i++];
            List sequences = (List)args[i++];
            TotalHits totalHits = (TotalHits)args[i];
            return new Hits(events, sequences, totalHits);
        });

        public Hits(@Nullable List<Event> events, @Nullable List<Sequence> sequences, @Nullable TotalHits totalHits) {
            this.events = events;
            this.sequences = sequences;
            this.totalHits = totalHits;
        }

        public static Hits fromXContent(XContentParser parser) throws IOException {
            return (Hits)PARSER.parse(parser, null);
        }

        public List<Event> events() {
            return this.events;
        }

        public List<Sequence> sequences() {
            return this.sequences;
        }

        public TotalHits totalHits() {
            return this.totalHits;
        }

        public int hashCode() {
            return Objects.hash(this.events, this.sequences, this.totalHits);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Hits that = (Hits)o;
            return Objects.equals(this.events, that.events) && Objects.equals(this.sequences, that.sequences) && Objects.equals(this.totalHits, that.totalHits);
        }

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> Event.fromXContent(p), new ParseField("events", new String[0]));
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)Sequence.PARSER, new ParseField("sequences", new String[0]));
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SearchHits.parseTotalHitsFragment((XContentParser)p), new ParseField("total", new String[0]));
        }

        private static final class Fields {
            static final String TOTAL = "total";
            static final String EVENTS = "events";
            static final String SEQUENCES = "sequences";

            private Fields() {
            }
        }
    }

    private static final class Fields {
        static final String TOOK = "took";
        static final String TIMED_OUT = "timed_out";
        static final String HITS = "hits";
        static final String ID = "id";
        static final String IS_RUNNING = "is_running";
        static final String IS_PARTIAL = "is_partial";

        private Fields() {
        }
    }

    public static class Sequence {
        private static final ParseField JOIN_KEYS = new ParseField("join_keys", new String[0]);
        private static final ParseField EVENTS = new ParseField("events", new String[0]);
        private static final ConstructingObjectParser<Sequence, Void> PARSER = new ConstructingObjectParser("eql/search_response_sequence", true, args -> {
            int i = 0;
            List joinKeys = (List)args[i++];
            List events = (List)args[i];
            return new Sequence(joinKeys, events);
        });
        private final List<Object> joinKeys;
        private final List<Event> events;

        public Sequence(List<Object> joinKeys, List<Event> events) {
            this.joinKeys = joinKeys == null ? Collections.emptyList() : joinKeys;
            this.events = events == null ? Collections.emptyList() : events;
        }

        public static Sequence fromXContent(XContentParser parser) {
            return (Sequence)PARSER.apply(parser, null);
        }

        public List<Object> joinKeys() {
            return this.joinKeys;
        }

        public List<Event> events() {
            return this.events;
        }

        public int hashCode() {
            return Objects.hash(this.joinKeys, this.events);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Sequence that = (Sequence)o;
            return Objects.equals(this.joinKeys, that.joinKeys) && Objects.equals(this.events, that.events);
        }

        static {
            PARSER.declareFieldArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> XContentParserUtils.parseFieldsValue((XContentParser)p), JOIN_KEYS, ObjectParser.ValueType.VALUE_ARRAY);
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> Event.fromXContent(p), EVENTS);
        }

        private static final class Fields {
            static final String JOIN_KEYS = "join_keys";
            static final String EVENTS = "events";

            private Fields() {
            }
        }
    }

    public static class Event {
        private static final ParseField INDEX = new ParseField("_index", new String[0]);
        private static final ParseField ID = new ParseField("_id", new String[0]);
        private static final ParseField SOURCE = new ParseField("_source", new String[0]);
        private static final ConstructingObjectParser<Event, Void> PARSER = new ConstructingObjectParser("eql/search_response_event", true, args -> new Event((String)args[0], (String)args[1], (BytesReference)args[2]));
        private final String index;
        private final String id;
        private final BytesReference source;
        private Map<String, Object> sourceAsMap;

        public Event(String index, String id, BytesReference source) {
            this.index = index;
            this.id = id;
            this.source = source;
        }

        public static Event fromXContent(XContentParser parser) throws IOException {
            return (Event)PARSER.apply(parser, null);
        }

        public String index() {
            return this.index;
        }

        public String id() {
            return this.id;
        }

        public BytesReference source() {
            return this.source;
        }

        public Map<String, Object> sourceAsMap() {
            if (this.source == null) {
                return null;
            }
            if (this.sourceAsMap != null) {
                return this.sourceAsMap;
            }
            this.sourceAsMap = SourceLookup.sourceAsMap((BytesReference)this.source);
            return this.sourceAsMap;
        }

        public int hashCode() {
            return Objects.hash(this.index, this.id, this.source);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Event other = (Event)obj;
            return Objects.equals(this.index, other.index) && Objects.equals(this.id, other.id) && Objects.equals(this.source, other.source);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), INDEX);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), ID);
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> {
                try (XContentBuilder builder = XContentBuilder.builder((XContent)p.contentType().xContent());){
                    builder.copyCurrentStructure(p);
                    BytesReference bytesReference = BytesReference.bytes((XContentBuilder)builder);
                    return bytesReference;
                }
            }, SOURCE);
        }

        private static final class Fields {
            static final String INDEX = "_index";
            static final String ID = "_id";
            static final String SOURCE = "_source";

            private Fields() {
            }
        }
    }
}

