/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.inference.preprocessing;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.ml.inference.NamedXContentObjectHelper;
import org.elasticsearch.client.ml.inference.preprocessing.PreProcessor;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class Multi
implements PreProcessor {
    public static final String NAME = "multi_encoding";
    public static final ParseField PROCESSORS = new ParseField("processors", new String[0]);
    public static final ParseField CUSTOM = new ParseField("custom", new String[0]);
    public static final ConstructingObjectParser<Multi, Void> PARSER = new ConstructingObjectParser("multi_encoding", true, a -> new Multi((List)a[0], (Boolean)a[1]));
    private final List<PreProcessor> processors;
    private final Boolean custom;

    public static Multi fromXContent(XContentParser parser) {
        return (Multi)PARSER.apply(parser, null);
    }

    Multi(List<PreProcessor> processors, Boolean custom) {
        this.processors = Objects.requireNonNull(processors, PROCESSORS.getPreferredName());
        this.custom = custom;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        NamedXContentObjectHelper.writeNamedObjects(builder, params, true, PROCESSORS.getPreferredName(), this.processors);
        if (this.custom != null) {
            builder.field(CUSTOM.getPreferredName(), this.custom);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Multi multi = (Multi)o;
        return Objects.equals(multi.processors, this.processors) && Objects.equals(this.custom, multi.custom);
    }

    public int hashCode() {
        return Objects.hash(this.custom, this.processors);
    }

    public static Builder builder(List<PreProcessor> processors) {
        return new Builder(processors);
    }

    static {
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, n) -> (PreProcessor)p.namedObject(PreProcessor.class, n, null), _unused -> {}, PROCESSORS);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), CUSTOM);
    }

    public static class Builder {
        private final List<PreProcessor> processors;
        private Boolean custom;

        public Builder(List<PreProcessor> processors) {
            this.processors = processors;
        }

        public Builder setCustom(boolean custom) {
            this.custom = custom;
            return this;
        }

        public Multi build() {
            return new Multi(this.processors, this.custom);
        }
    }
}

