/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security.user.privileges;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class ApplicationPrivilege
implements ToXContentObject {
    private static final ParseField APPLICATION = new ParseField("application", new String[0]);
    private static final ParseField NAME = new ParseField("name", new String[0]);
    private static final ParseField ACTIONS = new ParseField("actions", new String[0]);
    private static final ParseField METADATA = new ParseField("metadata", new String[0]);
    private final String application;
    private final String name;
    private final Set<String> actions;
    private final Map<String, Object> metadata;
    public static final ConstructingObjectParser<ApplicationPrivilege, String> PARSER = new ConstructingObjectParser("application_privilege", true, args -> new ApplicationPrivilege((String)args[0], (String)args[1], (Collection)args[2], (Map)args[3]));

    public ApplicationPrivilege(String application, String name, Collection<String> actions, @Nullable Map<String, Object> metadata) {
        if (Strings.isNullOrEmpty((String)application)) {
            throw new IllegalArgumentException("application name must be provided");
        }
        this.application = application;
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("privilege name must be provided");
        }
        this.name = name;
        if (actions == null || actions.isEmpty()) {
            throw new IllegalArgumentException("actions must be provided");
        }
        this.actions = Collections.unmodifiableSet(new HashSet<String>(actions));
        this.metadata = metadata == null || metadata.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(metadata);
    }

    public String getApplication() {
        return this.application;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getActions() {
        return this.actions;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationPrivilege that = (ApplicationPrivilege)o;
        return Objects.equals(this.application, that.application) && Objects.equals(this.name, that.name) && Objects.equals(this.actions, that.actions) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.application, this.name, this.actions, this.metadata);
    }

    static ApplicationPrivilege fromXContent(XContentParser parser) throws IOException {
        return (ApplicationPrivilege)PARSER.parse(parser, null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field(APPLICATION.getPreferredName(), this.application).field(NAME.getPreferredName(), this.name).field(ACTIONS.getPreferredName(), this.actions);
        if (this.metadata != null && !this.metadata.isEmpty()) {
            builder.field(METADATA.getPreferredName(), this.metadata);
        }
        return builder.endObject();
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), APPLICATION);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), ACTIONS);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), XContentParser::map, METADATA, ObjectParser.ValueType.OBJECT);
    }

    public static final class Builder {
        private String applicationName = null;
        private String privilegeName = null;
        private Collection<String> actions = null;
        private Map<String, Object> metadata = null;

        private Builder() {
        }

        public Builder application(String name) {
            this.applicationName = Objects.requireNonNull(name, "application name must be provided");
            return this;
        }

        public Builder privilege(String name) {
            this.privilegeName = Objects.requireNonNull(name, "privilege name must be provided");
            return this;
        }

        public Builder actions(String ... actions) {
            this.actions = Arrays.asList(Objects.requireNonNull(actions));
            return this;
        }

        public Builder actions(Collection<String> actions) {
            this.actions = Objects.requireNonNull(actions);
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public ApplicationPrivilege build() {
            return new ApplicationPrivilege(this.applicationName, this.privilegeName, this.actions, this.metadata);
        }
    }
}

