/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public final class NodesResponseHeader {
    public static final ParseField TOTAL = new ParseField("total", new String[0]);
    public static final ParseField SUCCESSFUL = new ParseField("successful", new String[0]);
    public static final ParseField FAILED = new ParseField("failed", new String[0]);
    public static final ParseField FAILURES = new ParseField("failures", new String[0]);
    public static final ConstructingObjectParser<NodesResponseHeader, Void> PARSER = new ConstructingObjectParser("nodes_response_header", true, a -> {
        int i = 0;
        int total = (Integer)a[i++];
        int successful = (Integer)a[i++];
        int failed = (Integer)a[i++];
        List failures = (List)a[i++];
        return new NodesResponseHeader(total, successful, failed, failures);
    });
    private final int total;
    private final int successful;
    private final int failed;
    private final List<ElasticsearchException> failures;

    public NodesResponseHeader(int total, int successful, int failed, @Nullable List<ElasticsearchException> failures) {
        this.total = total;
        this.successful = successful;
        this.failed = failed;
        this.failures = failures == null ? Collections.emptyList() : failures;
    }

    public static NodesResponseHeader fromXContent(XContentParser parser, Void context) throws IOException {
        return (NodesResponseHeader)PARSER.parse(parser, (Object)context);
    }

    public int getTotal() {
        return this.total;
    }

    public int getFailed() {
        return this.failed;
    }

    public int getSuccessful() {
        return this.successful;
    }

    public List<ElasticsearchException> getFailures() {
        return this.failures;
    }

    public boolean hasFailures() {
        return !this.failures.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodesResponseHeader that = (NodesResponseHeader)o;
        return this.total == that.total && this.successful == that.successful && this.failed == that.failed && Objects.equals(this.failures, that.failures);
    }

    public int hashCode() {
        return Objects.hash(this.total, this.successful, this.failed, this.failures);
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), TOTAL);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), SUCCESSFUL);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), FAILED);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ElasticsearchException.fromXContent((XContentParser)p), FAILURES);
    }
}

