/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.ValidationException;
import org.elasticsearch.client.core.PageParams;
import org.elasticsearch.core.Nullable;

public class GetDataFrameAnalyticsRequest
implements Validatable {
    public static final String ALLOW_NO_MATCH = "allow_no_match";
    public static final String EXCLUDE_GENERATED = "exclude_generated";
    private final List<String> ids;
    private Boolean allowNoMatch;
    private PageParams pageParams;
    private Boolean excludeGenerated;

    public static GetDataFrameAnalyticsRequest getAllDataFrameAnalyticsRequest() {
        return new GetDataFrameAnalyticsRequest("_all");
    }

    public GetDataFrameAnalyticsRequest(String ... ids) {
        this.ids = Arrays.asList(ids);
    }

    public List<String> getIds() {
        return this.ids;
    }

    public Boolean getAllowNoMatch() {
        return this.allowNoMatch;
    }

    public void setExcludeGenerated(boolean excludeGenerated) {
        this.excludeGenerated = excludeGenerated;
    }

    public Boolean getExcludeGenerated() {
        return this.excludeGenerated;
    }

    public GetDataFrameAnalyticsRequest setAllowNoMatch(boolean allowNoMatch) {
        this.allowNoMatch = allowNoMatch;
        return this;
    }

    public PageParams getPageParams() {
        return this.pageParams;
    }

    public GetDataFrameAnalyticsRequest setPageParams(@Nullable PageParams pageParams) {
        this.pageParams = pageParams;
        return this;
    }

    @Override
    public Optional<ValidationException> validate() {
        if (this.ids == null || this.ids.isEmpty()) {
            return Optional.of(ValidationException.withError("data frame analytics id must not be null"));
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetDataFrameAnalyticsRequest other = (GetDataFrameAnalyticsRequest)o;
        return Objects.equals(this.ids, other.ids) && Objects.equals(this.allowNoMatch, other.allowNoMatch) && Objects.equals(this.excludeGenerated, other.excludeGenerated) && Objects.equals(this.pageParams, other.pageParams);
    }

    public int hashCode() {
        return Objects.hash(this.ids, this.allowNoMatch, this.excludeGenerated, this.pageParams);
    }
}

