/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.security.user.User;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ContextParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class AuthenticateResponse
implements ToXContentObject {
    static final ParseField USERNAME = new ParseField("username", new String[0]);
    static final ParseField ROLES = new ParseField("roles", new String[0]);
    static final ParseField METADATA = new ParseField("metadata", new String[0]);
    static final ParseField FULL_NAME = new ParseField("full_name", new String[0]);
    static final ParseField EMAIL = new ParseField("email", new String[0]);
    static final ParseField ENABLED = new ParseField("enabled", new String[0]);
    static final ParseField AUTHENTICATION_REALM = new ParseField("authentication_realm", new String[0]);
    static final ParseField LOOKUP_REALM = new ParseField("lookup_realm", new String[0]);
    static final ParseField REALM_NAME = new ParseField("name", new String[0]);
    static final ParseField REALM_TYPE = new ParseField("type", new String[0]);
    static final ParseField AUTHENTICATION_TYPE = new ParseField("authentication_type", new String[0]);
    static final ParseField TOKEN = new ParseField("token", new String[0]);
    private static final ConstructingObjectParser<AuthenticateResponse, Void> PARSER = new ConstructingObjectParser("client_security_authenticate_response", true, a -> new AuthenticateResponse(new User((String)a[0], (List)a[1], (Map)a[2], (String)a[3], (String)a[4]), (Boolean)a[5], (RealmInfo)a[6], (RealmInfo)a[7], (String)a[8], (Map)a[9]));
    private final User user;
    private final boolean enabled;
    private final RealmInfo authenticationRealm;
    private final RealmInfo lookupRealm;
    private final String authenticationType;
    @Nullable
    private final Map<String, Object> token;

    public AuthenticateResponse(User user, boolean enabled, RealmInfo authenticationRealm, RealmInfo lookupRealm, String authenticationType) {
        this(user, enabled, authenticationRealm, lookupRealm, authenticationType, null);
    }

    public AuthenticateResponse(User user, boolean enabled, RealmInfo authenticationRealm, RealmInfo lookupRealm, String authenticationType, @Nullable Map<String, Object> token) {
        this.user = user;
        this.enabled = enabled;
        this.authenticationRealm = authenticationRealm;
        this.lookupRealm = lookupRealm;
        this.authenticationType = authenticationType;
        this.token = token;
    }

    public User getUser() {
        return this.user;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public RealmInfo getAuthenticationRealm() {
        return this.authenticationRealm;
    }

    public RealmInfo getLookupRealm() {
        return this.lookupRealm;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public Map<String, Object> getToken() {
        return this.token;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(USERNAME.getPreferredName(), this.user.getUsername());
        builder.field(ROLES.getPreferredName(), this.user.getRoles());
        builder.field(METADATA.getPreferredName(), this.user.getMetadata());
        if (this.user.getFullName() != null) {
            builder.field(FULL_NAME.getPreferredName(), this.user.getFullName());
        }
        if (this.user.getEmail() != null) {
            builder.field(EMAIL.getPreferredName(), this.user.getEmail());
        }
        builder.field(ENABLED.getPreferredName(), this.enabled);
        builder.startObject(AUTHENTICATION_REALM.getPreferredName());
        builder.field(REALM_NAME.getPreferredName(), this.authenticationRealm.getName());
        builder.field(REALM_TYPE.getPreferredName(), this.authenticationRealm.getType());
        builder.endObject();
        builder.startObject(LOOKUP_REALM.getPreferredName());
        builder.field(REALM_NAME.getPreferredName(), this.lookupRealm.getName());
        builder.field(REALM_TYPE.getPreferredName(), this.lookupRealm.getType());
        builder.endObject();
        builder.field(AUTHENTICATION_TYPE.getPreferredName(), this.authenticationType);
        if (this.token != null) {
            builder.field(TOKEN.getPreferredName(), this.token);
        }
        return builder.endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticateResponse that = (AuthenticateResponse)o;
        return this.enabled == that.enabled && Objects.equals(this.user, that.user) && Objects.equals(this.authenticationRealm, that.authenticationRealm) && Objects.equals(this.lookupRealm, that.lookupRealm) && Objects.equals(this.authenticationType, that.authenticationType) && Objects.equals(this.token, that.token);
    }

    public int hashCode() {
        return Objects.hash(this.user, this.enabled, this.authenticationRealm, this.lookupRealm, this.authenticationType, this.token);
    }

    public static AuthenticateResponse fromXContent(XContentParser parser) throws IOException {
        return (AuthenticateResponse)PARSER.parse(parser, null);
    }

    static {
        ConstructingObjectParser realmInfoParser = new ConstructingObjectParser("realm_info", true, a -> new RealmInfo((String)a[0], (String)a[1]));
        realmInfoParser.declareString(ConstructingObjectParser.constructorArg(), REALM_NAME);
        realmInfoParser.declareString(ConstructingObjectParser.constructorArg(), REALM_TYPE);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), USERNAME);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), ROLES);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (parser, c) -> parser.map(), METADATA);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), FULL_NAME);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), EMAIL);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), ENABLED);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (ContextParser)realmInfoParser, AUTHENTICATION_REALM);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (ContextParser)realmInfoParser, LOOKUP_REALM);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), AUTHENTICATION_TYPE);
        PARSER.declareObjectOrNull(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), null, TOKEN);
    }

    public static class RealmInfo {
        private String name;
        private String type;

        RealmInfo(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RealmInfo realmInfo = (RealmInfo)o;
            return Objects.equals(this.name, realmInfo.name) && Objects.equals(this.type, realmInfo.type);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type);
        }
    }
}

