/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.job.process;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.ml.job.config.Job;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class TimingStats
implements ToXContentObject {
    public static final ParseField BUCKET_COUNT = new ParseField("bucket_count", new String[0]);
    public static final ParseField MIN_BUCKET_PROCESSING_TIME_MS = new ParseField("minimum_bucket_processing_time_ms", new String[0]);
    public static final ParseField MAX_BUCKET_PROCESSING_TIME_MS = new ParseField("maximum_bucket_processing_time_ms", new String[0]);
    public static final ParseField AVG_BUCKET_PROCESSING_TIME_MS = new ParseField("average_bucket_processing_time_ms", new String[0]);
    public static final ParseField EXPONENTIAL_AVG_BUCKET_PROCESSING_TIME_MS = new ParseField("exponential_average_bucket_processing_time_ms", new String[0]);
    public static final ConstructingObjectParser<TimingStats, Void> PARSER = new ConstructingObjectParser("timing_stats", true, args -> new TimingStats((String)args[0], (Long)args[1], (Double)args[2], (Double)args[3], (Double)args[4], (Double)args[5]));
    private final String jobId;
    private long bucketCount;
    private Double minBucketProcessingTimeMs;
    private Double maxBucketProcessingTimeMs;
    private Double avgBucketProcessingTimeMs;
    private Double exponentialAvgBucketProcessingTimeMs;

    public TimingStats(String jobId, long bucketCount, @Nullable Double minBucketProcessingTimeMs, @Nullable Double maxBucketProcessingTimeMs, @Nullable Double avgBucketProcessingTimeMs, @Nullable Double exponentialAvgBucketProcessingTimeMs) {
        this.jobId = jobId;
        this.bucketCount = bucketCount;
        this.minBucketProcessingTimeMs = minBucketProcessingTimeMs;
        this.maxBucketProcessingTimeMs = maxBucketProcessingTimeMs;
        this.avgBucketProcessingTimeMs = avgBucketProcessingTimeMs;
        this.exponentialAvgBucketProcessingTimeMs = exponentialAvgBucketProcessingTimeMs;
    }

    public String getJobId() {
        return this.jobId;
    }

    public long getBucketCount() {
        return this.bucketCount;
    }

    public Double getMinBucketProcessingTimeMs() {
        return this.minBucketProcessingTimeMs;
    }

    public Double getMaxBucketProcessingTimeMs() {
        return this.maxBucketProcessingTimeMs;
    }

    public Double getAvgBucketProcessingTimeMs() {
        return this.avgBucketProcessingTimeMs;
    }

    public Double getExponentialAvgBucketProcessingTimeMs() {
        return this.exponentialAvgBucketProcessingTimeMs;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(BUCKET_COUNT.getPreferredName(), this.bucketCount);
        if (this.minBucketProcessingTimeMs != null) {
            builder.field(MIN_BUCKET_PROCESSING_TIME_MS.getPreferredName(), this.minBucketProcessingTimeMs);
        }
        if (this.maxBucketProcessingTimeMs != null) {
            builder.field(MAX_BUCKET_PROCESSING_TIME_MS.getPreferredName(), this.maxBucketProcessingTimeMs);
        }
        if (this.avgBucketProcessingTimeMs != null) {
            builder.field(AVG_BUCKET_PROCESSING_TIME_MS.getPreferredName(), this.avgBucketProcessingTimeMs);
        }
        if (this.exponentialAvgBucketProcessingTimeMs != null) {
            builder.field(EXPONENTIAL_AVG_BUCKET_PROCESSING_TIME_MS.getPreferredName(), this.exponentialAvgBucketProcessingTimeMs);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimingStats that = (TimingStats)o;
        return Objects.equals(this.jobId, that.jobId) && this.bucketCount == that.bucketCount && Objects.equals(this.minBucketProcessingTimeMs, that.minBucketProcessingTimeMs) && Objects.equals(this.maxBucketProcessingTimeMs, that.maxBucketProcessingTimeMs) && Objects.equals(this.avgBucketProcessingTimeMs, that.avgBucketProcessingTimeMs) && Objects.equals(this.exponentialAvgBucketProcessingTimeMs, that.exponentialAvgBucketProcessingTimeMs);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.bucketCount, this.minBucketProcessingTimeMs, this.maxBucketProcessingTimeMs, this.avgBucketProcessingTimeMs, this.exponentialAvgBucketProcessingTimeMs);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), BUCKET_COUNT);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), MIN_BUCKET_PROCESSING_TIME_MS);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), MAX_BUCKET_PROCESSING_TIME_MS);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), AVG_BUCKET_PROCESSING_TIME_MS);
        PARSER.declareDouble(ConstructingObjectParser.optionalConstructorArg(), EXPONENTIAL_AVG_BUCKET_PROCESSING_TIME_MS);
    }
}

