/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.dataframe.transforms;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.dataframe.transforms.DataFrameIndexerPosition;
import org.elasticsearch.client.dataframe.transforms.DataFrameTransformProgress;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public class DataFrameTransformCheckpointStats {
    public static final ParseField CHECKPOINT = new ParseField("checkpoint", new String[0]);
    public static final ParseField POSITION = new ParseField("position", new String[0]);
    public static final ParseField CHECKPOINT_PROGRESS = new ParseField("checkpoint_progress", new String[0]);
    public static final ParseField TIMESTAMP_MILLIS = new ParseField("timestamp_millis", new String[0]);
    public static final ParseField TIME_UPPER_BOUND_MILLIS = new ParseField("time_upper_bound_millis", new String[0]);
    public static final DataFrameTransformCheckpointStats EMPTY = new DataFrameTransformCheckpointStats(0L, null, null, 0L, 0L);
    private final long checkpoint;
    private final DataFrameIndexerPosition position;
    private final DataFrameTransformProgress checkpointProgress;
    private final long timestampMillis;
    private final long timeUpperBoundMillis;
    public static final ConstructingObjectParser<DataFrameTransformCheckpointStats, Void> LENIENT_PARSER = new ConstructingObjectParser("data_frame_transform_checkpoint_stats", true, args -> {
        long checkpoint = args[0] == null ? 0L : (Long)args[0];
        DataFrameIndexerPosition position = (DataFrameIndexerPosition)args[1];
        DataFrameTransformProgress checkpointProgress = (DataFrameTransformProgress)args[2];
        long timestamp = args[3] == null ? 0L : (Long)args[3];
        long timeUpperBound = args[4] == null ? 0L : (Long)args[4];
        return new DataFrameTransformCheckpointStats(checkpoint, position, checkpointProgress, timestamp, timeUpperBound);
    });

    public static DataFrameTransformCheckpointStats fromXContent(XContentParser parser) throws IOException {
        return (DataFrameTransformCheckpointStats)LENIENT_PARSER.parse(parser, null);
    }

    public DataFrameTransformCheckpointStats(long checkpoint, DataFrameIndexerPosition position, DataFrameTransformProgress checkpointProgress, long timestampMillis, long timeUpperBoundMillis) {
        this.checkpoint = checkpoint;
        this.position = position;
        this.checkpointProgress = checkpointProgress;
        this.timestampMillis = timestampMillis;
        this.timeUpperBoundMillis = timeUpperBoundMillis;
    }

    public long getCheckpoint() {
        return this.checkpoint;
    }

    public DataFrameIndexerPosition getPosition() {
        return this.position;
    }

    public DataFrameTransformProgress getCheckpointProgress() {
        return this.checkpointProgress;
    }

    public long getTimestampMillis() {
        return this.timestampMillis;
    }

    public long getTimeUpperBoundMillis() {
        return this.timeUpperBoundMillis;
    }

    public int hashCode() {
        return Objects.hash(this.checkpoint, this.position, this.checkpointProgress, this.timestampMillis, this.timeUpperBoundMillis);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DataFrameTransformCheckpointStats that = (DataFrameTransformCheckpointStats)other;
        return this.checkpoint == that.checkpoint && Objects.equals(this.position, that.position) && Objects.equals(this.checkpointProgress, that.checkpointProgress) && this.timestampMillis == that.timestampMillis && this.timeUpperBoundMillis == that.timeUpperBoundMillis;
    }

    static {
        LENIENT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), CHECKPOINT);
        LENIENT_PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), DataFrameIndexerPosition.PARSER, POSITION);
        LENIENT_PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), DataFrameTransformProgress.PARSER, CHECKPOINT_PROGRESS);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), TIMESTAMP_MILLIS);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), TIME_UPPER_BOUND_MILLIS);
    }
}

