/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.dataframe;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.ValidationException;
import org.elasticsearch.client.dataframe.transforms.DataFrameTransformConfigUpdate;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class UpdateDataFrameTransformRequest
implements ToXContentObject,
Validatable {
    private final DataFrameTransformConfigUpdate update;
    private final String id;
    private Boolean deferValidation;

    public UpdateDataFrameTransformRequest(DataFrameTransformConfigUpdate update, String id) {
        this.update = update;
        this.id = id;
    }

    public DataFrameTransformConfigUpdate getUpdate() {
        return this.update;
    }

    public Boolean getDeferValidation() {
        return this.deferValidation;
    }

    public String getId() {
        return this.id;
    }

    public void setDeferValidation(boolean deferValidation) {
        this.deferValidation = deferValidation;
    }

    @Override
    public Optional<ValidationException> validate() {
        ValidationException validationException = new ValidationException();
        if (this.update == null) {
            validationException.addValidationError("put requires a non-null data frame config update object");
        }
        if (this.id == null) {
            validationException.addValidationError("data frame transform id cannot be null");
        }
        if (validationException.validationErrors().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(validationException);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.update.toXContent(builder, params);
    }

    public int hashCode() {
        return Objects.hash(this.update, this.deferValidation, this.id);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateDataFrameTransformRequest other = (UpdateDataFrameTransformRequest)obj;
        return Objects.equals(this.update, other.update) && Objects.equals(this.id, other.id) && Objects.equals(this.deferValidation, other.deferValidation);
    }
}

