/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.dataframe;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.ValidationException;
import org.elasticsearch.client.dataframe.transforms.DataFrameTransformConfig;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class PutDataFrameTransformRequest
implements ToXContentObject,
Validatable {
    public static final String DEFER_VALIDATION = "defer_validation";
    private final DataFrameTransformConfig config;
    private Boolean deferValidation;

    public PutDataFrameTransformRequest(DataFrameTransformConfig config) {
        this.config = config;
    }

    public DataFrameTransformConfig getConfig() {
        return this.config;
    }

    public Boolean getDeferValidation() {
        return this.deferValidation;
    }

    public void setDeferValidation(boolean deferValidation) {
        this.deferValidation = deferValidation;
    }

    @Override
    public Optional<ValidationException> validate() {
        ValidationException validationException = new ValidationException();
        if (this.config == null) {
            validationException.addValidationError("put requires a non-null data frame config");
            return Optional.of(validationException);
        }
        if (this.config.getId() == null) {
            validationException.addValidationError("data frame transform id cannot be null");
        }
        if (this.config.getSource() == null) {
            validationException.addValidationError("data frame transform source cannot be null");
        }
        if (this.config.getDestination() == null) {
            validationException.addValidationError("data frame transform destination cannot be null");
        }
        if (validationException.validationErrors().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(validationException);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.config.toXContent(builder, params);
    }

    public int hashCode() {
        return Objects.hash(this.config);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PutDataFrameTransformRequest other = (PutDataFrameTransformRequest)obj;
        return Objects.equals(this.config, other.config);
    }
}

