/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transform.transforms.pivot;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.transform.transforms.pivot.DateHistogramGroupSource;
import org.elasticsearch.client.transform.transforms.pivot.HistogramGroupSource;
import org.elasticsearch.client.transform.transforms.pivot.SingleGroupSource;
import org.elasticsearch.client.transform.transforms.pivot.TermsGroupSource;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;

public class GroupConfig
implements ToXContentObject {
    private final Map<String, SingleGroupSource> groups;

    public static GroupConfig fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        LinkedHashMap<String, SingleGroupSource> groups = new LinkedHashMap<String, SingleGroupSource>();
        if (parser.currentToken() != XContentParser.Token.START_OBJECT && (token = parser.nextToken()) != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "Failed to parse object: Expected START_OBJECT but was: " + token, new Object[0]);
        }
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, () -> ((XContentParser)parser).getTokenLocation());
            token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                if (token != XContentParser.Token.START_ARRAY) continue;
                parser.skipChildren();
                continue;
            }
            String destinationFieldName = parser.currentName();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, () -> ((XContentParser)parser).getTokenLocation());
            token = parser.nextToken();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, () -> ((XContentParser)parser).getTokenLocation());
            String groupType = parser.currentName();
            token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                GroupConfig.consumeUntilEndObject(parser, 1);
                continue;
            }
            SingleGroupSource groupSource = null;
            switch (groupType) {
                case "terms": {
                    groupSource = TermsGroupSource.fromXContent(parser);
                    break;
                }
                case "histogram": {
                    groupSource = HistogramGroupSource.fromXContent(parser);
                    break;
                }
                case "date_histogram": {
                    groupSource = DateHistogramGroupSource.fromXContent(parser);
                    break;
                }
                default: {
                    GroupConfig.consumeUntilEndObject(parser, 2);
                }
            }
            if (groupSource == null) continue;
            groups.put(destinationFieldName, groupSource);
            parser.nextToken();
        }
        return new GroupConfig(groups);
    }

    private static void consumeUntilEndObject(XContentParser parser, int endObjectCount) throws IOException {
        do {
            XContentParser.Token token;
            if ((token = parser.nextToken()) == XContentParser.Token.START_OBJECT) {
                ++endObjectCount;
                continue;
            }
            if (token != XContentParser.Token.END_OBJECT) continue;
            --endObjectCount;
        } while (endObjectCount != 0);
    }

    GroupConfig(Map<String, SingleGroupSource> groups) {
        this.groups = groups;
    }

    public Map<String, SingleGroupSource> getGroups() {
        return this.groups;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (Map.Entry<String, SingleGroupSource> entry : this.groups.entrySet()) {
            builder.startObject(entry.getKey());
            builder.field(entry.getValue().getType().value(), (ToXContent)entry.getValue());
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GroupConfig that = (GroupConfig)other;
        return Objects.equals(this.groups, that.groups);
    }

    public int hashCode() {
        return Objects.hash(this.groups);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, SingleGroupSource> groups = new HashMap<String, SingleGroupSource>();

        public Builder groupBy(String name, SingleGroupSource group) {
            this.groups.put(name, group);
            return this;
        }

        public GroupConfig build() {
            return new GroupConfig(this.groups);
        }
    }
}

