/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.job.config;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.ml.job.config.AnalysisConfig;
import org.elasticsearch.client.ml.job.config.AnalysisLimits;
import org.elasticsearch.client.ml.job.config.DetectionRule;
import org.elasticsearch.client.ml.job.config.Detector;
import org.elasticsearch.client.ml.job.config.Job;
import org.elasticsearch.client.ml.job.config.ModelPlotConfig;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class JobUpdate
implements ToXContentObject {
    public static final ParseField DETECTORS = new ParseField("detectors", new String[0]);
    public static final ConstructingObjectParser<Builder, Void> PARSER = new ConstructingObjectParser("job_update", true, args -> new Builder((String)args[0]));
    private final String jobId;
    private final List<String> groups;
    private final String description;
    private final List<DetectorUpdate> detectorUpdates;
    private final ModelPlotConfig modelPlotConfig;
    private final AnalysisLimits analysisLimits;
    private final Long renormalizationWindowDays;
    private final TimeValue backgroundPersistInterval;
    private final Long modelSnapshotRetentionDays;
    private final Long dailyModelSnapshotRetentionAfterDays;
    private final Long resultsRetentionDays;
    private final List<String> categorizationFilters;
    private final Map<String, Object> customSettings;
    private final Boolean allowLazyOpen;

    private JobUpdate(String jobId, @Nullable List<String> groups, @Nullable String description, @Nullable List<DetectorUpdate> detectorUpdates, @Nullable ModelPlotConfig modelPlotConfig, @Nullable AnalysisLimits analysisLimits, @Nullable TimeValue backgroundPersistInterval, @Nullable Long renormalizationWindowDays, @Nullable Long resultsRetentionDays, @Nullable Long modelSnapshotRetentionDays, @Nullable Long dailyModelSnapshotRetentionAfterDays, @Nullable List<String> categorizationFilters, @Nullable Map<String, Object> customSettings, @Nullable Boolean allowLazyOpen) {
        this.jobId = jobId;
        this.groups = groups;
        this.description = description;
        this.detectorUpdates = detectorUpdates;
        this.modelPlotConfig = modelPlotConfig;
        this.analysisLimits = analysisLimits;
        this.renormalizationWindowDays = renormalizationWindowDays;
        this.backgroundPersistInterval = backgroundPersistInterval;
        this.modelSnapshotRetentionDays = modelSnapshotRetentionDays;
        this.dailyModelSnapshotRetentionAfterDays = dailyModelSnapshotRetentionAfterDays;
        this.resultsRetentionDays = resultsRetentionDays;
        this.categorizationFilters = categorizationFilters;
        this.customSettings = customSettings;
        this.allowLazyOpen = allowLazyOpen;
    }

    public String getJobId() {
        return this.jobId;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public String getDescription() {
        return this.description;
    }

    public List<DetectorUpdate> getDetectorUpdates() {
        return this.detectorUpdates;
    }

    public ModelPlotConfig getModelPlotConfig() {
        return this.modelPlotConfig;
    }

    public AnalysisLimits getAnalysisLimits() {
        return this.analysisLimits;
    }

    public Long getRenormalizationWindowDays() {
        return this.renormalizationWindowDays;
    }

    public TimeValue getBackgroundPersistInterval() {
        return this.backgroundPersistInterval;
    }

    public Long getModelSnapshotRetentionDays() {
        return this.modelSnapshotRetentionDays;
    }

    public Long getResultsRetentionDays() {
        return this.resultsRetentionDays;
    }

    public List<String> getCategorizationFilters() {
        return this.categorizationFilters;
    }

    public Map<String, Object> getCustomSettings() {
        return this.customSettings;
    }

    public Boolean getAllowLazyOpen() {
        return this.allowLazyOpen;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        if (this.groups != null) {
            builder.field(Job.GROUPS.getPreferredName(), this.groups);
        }
        if (this.description != null) {
            builder.field(Job.DESCRIPTION.getPreferredName(), this.description);
        }
        if (this.detectorUpdates != null) {
            builder.field(DETECTORS.getPreferredName(), this.detectorUpdates);
        }
        if (this.modelPlotConfig != null) {
            builder.field(Job.MODEL_PLOT_CONFIG.getPreferredName(), (ToXContent)this.modelPlotConfig);
        }
        if (this.analysisLimits != null) {
            builder.field(Job.ANALYSIS_LIMITS.getPreferredName(), (ToXContent)this.analysisLimits);
        }
        if (this.renormalizationWindowDays != null) {
            builder.field(Job.RENORMALIZATION_WINDOW_DAYS.getPreferredName(), this.renormalizationWindowDays);
        }
        if (this.backgroundPersistInterval != null) {
            builder.field(Job.BACKGROUND_PERSIST_INTERVAL.getPreferredName(), (Object)this.backgroundPersistInterval);
        }
        if (this.modelSnapshotRetentionDays != null) {
            builder.field(Job.MODEL_SNAPSHOT_RETENTION_DAYS.getPreferredName(), this.modelSnapshotRetentionDays);
        }
        if (this.dailyModelSnapshotRetentionAfterDays != null) {
            builder.field(Job.DAILY_MODEL_SNAPSHOT_RETENTION_AFTER_DAYS.getPreferredName(), this.dailyModelSnapshotRetentionAfterDays);
        }
        if (this.resultsRetentionDays != null) {
            builder.field(Job.RESULTS_RETENTION_DAYS.getPreferredName(), this.resultsRetentionDays);
        }
        if (this.categorizationFilters != null) {
            builder.field(AnalysisConfig.CATEGORIZATION_FILTERS.getPreferredName(), this.categorizationFilters);
        }
        if (this.customSettings != null) {
            builder.field(Job.CUSTOM_SETTINGS.getPreferredName(), this.customSettings);
        }
        if (this.allowLazyOpen != null) {
            builder.field(Job.ALLOW_LAZY_OPEN.getPreferredName(), this.allowLazyOpen);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        JobUpdate that = (JobUpdate)other;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.groups, that.groups) && Objects.equals(this.description, that.description) && Objects.equals(this.detectorUpdates, that.detectorUpdates) && Objects.equals(this.modelPlotConfig, that.modelPlotConfig) && Objects.equals(this.analysisLimits, that.analysisLimits) && Objects.equals(this.renormalizationWindowDays, that.renormalizationWindowDays) && Objects.equals(this.backgroundPersistInterval, that.backgroundPersistInterval) && Objects.equals(this.modelSnapshotRetentionDays, that.modelSnapshotRetentionDays) && Objects.equals(this.dailyModelSnapshotRetentionAfterDays, that.dailyModelSnapshotRetentionAfterDays) && Objects.equals(this.resultsRetentionDays, that.resultsRetentionDays) && Objects.equals(this.categorizationFilters, that.categorizationFilters) && Objects.equals(this.customSettings, that.customSettings) && Objects.equals(this.allowLazyOpen, that.allowLazyOpen);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.groups, this.description, this.detectorUpdates, this.modelPlotConfig, this.analysisLimits, this.renormalizationWindowDays, this.backgroundPersistInterval, this.modelSnapshotRetentionDays, this.dailyModelSnapshotRetentionAfterDays, this.resultsRetentionDays, this.categorizationFilters, this.customSettings, this.allowLazyOpen);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), Job.ID);
        PARSER.declareStringArray(Builder::setGroups, Job.GROUPS);
        PARSER.declareStringOrNull(Builder::setDescription, Job.DESCRIPTION);
        PARSER.declareObjectArray(Builder::setDetectorUpdates, DetectorUpdate.PARSER, DETECTORS);
        PARSER.declareObject(Builder::setModelPlotConfig, ModelPlotConfig.PARSER, Job.MODEL_PLOT_CONFIG);
        PARSER.declareObject(Builder::setAnalysisLimits, AnalysisLimits.PARSER, Job.ANALYSIS_LIMITS);
        PARSER.declareString((builder, val) -> builder.setBackgroundPersistInterval(TimeValue.parseTimeValue((String)val, (String)Job.BACKGROUND_PERSIST_INTERVAL.getPreferredName())), Job.BACKGROUND_PERSIST_INTERVAL);
        PARSER.declareLong(Builder::setRenormalizationWindowDays, Job.RENORMALIZATION_WINDOW_DAYS);
        PARSER.declareLong(Builder::setResultsRetentionDays, Job.RESULTS_RETENTION_DAYS);
        PARSER.declareLong(Builder::setModelSnapshotRetentionDays, Job.MODEL_SNAPSHOT_RETENTION_DAYS);
        PARSER.declareLong(Builder::setDailyModelSnapshotRetentionAfterDays, Job.DAILY_MODEL_SNAPSHOT_RETENTION_AFTER_DAYS);
        PARSER.declareStringArray(Builder::setCategorizationFilters, AnalysisConfig.CATEGORIZATION_FILTERS);
        PARSER.declareField(Builder::setCustomSettings, (p, c) -> p.map(), Job.CUSTOM_SETTINGS, ObjectParser.ValueType.OBJECT);
        PARSER.declareBoolean(Builder::setAllowLazyOpen, Job.ALLOW_LAZY_OPEN);
    }

    public static class Builder {
        private final String jobId;
        private List<String> groups;
        private String description;
        private List<DetectorUpdate> detectorUpdates;
        private ModelPlotConfig modelPlotConfig;
        private AnalysisLimits analysisLimits;
        private Long renormalizationWindowDays;
        private TimeValue backgroundPersistInterval;
        private Long modelSnapshotRetentionDays;
        private Long dailyModelSnapshotRetentionAfterDays;
        private Long resultsRetentionDays;
        private List<String> categorizationFilters;
        private Map<String, Object> customSettings;
        private Boolean allowLazyOpen;

        public Builder(String jobId) {
            this.jobId = jobId;
        }

        public Builder setGroups(List<String> groups) {
            this.groups = groups;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setDetectorUpdates(List<DetectorUpdate> detectorUpdates) {
            this.detectorUpdates = detectorUpdates;
            return this;
        }

        public Builder setModelPlotConfig(ModelPlotConfig modelPlotConfig) {
            this.modelPlotConfig = modelPlotConfig;
            return this;
        }

        public Builder setAnalysisLimits(AnalysisLimits analysisLimits) {
            this.analysisLimits = analysisLimits;
            return this;
        }

        public Builder setRenormalizationWindowDays(Long renormalizationWindowDays) {
            this.renormalizationWindowDays = renormalizationWindowDays;
            return this;
        }

        public Builder setBackgroundPersistInterval(TimeValue backgroundPersistInterval) {
            this.backgroundPersistInterval = backgroundPersistInterval;
            return this;
        }

        public Builder setModelSnapshotRetentionDays(Long modelSnapshotRetentionDays) {
            this.modelSnapshotRetentionDays = modelSnapshotRetentionDays;
            return this;
        }

        public Builder setDailyModelSnapshotRetentionAfterDays(Long dailyModelSnapshotRetentionAfterDays) {
            this.dailyModelSnapshotRetentionAfterDays = dailyModelSnapshotRetentionAfterDays;
            return this;
        }

        public Builder setResultsRetentionDays(Long resultsRetentionDays) {
            this.resultsRetentionDays = resultsRetentionDays;
            return this;
        }

        public Builder setCategorizationFilters(List<String> categorizationFilters) {
            this.categorizationFilters = categorizationFilters;
            return this;
        }

        public Builder setCustomSettings(Map<String, Object> customSettings) {
            this.customSettings = customSettings;
            return this;
        }

        public Builder setAllowLazyOpen(boolean allowLazyOpen) {
            this.allowLazyOpen = allowLazyOpen;
            return this;
        }

        public JobUpdate build() {
            return new JobUpdate(this.jobId, this.groups, this.description, this.detectorUpdates, this.modelPlotConfig, this.analysisLimits, this.backgroundPersistInterval, this.renormalizationWindowDays, this.resultsRetentionDays, this.modelSnapshotRetentionDays, this.dailyModelSnapshotRetentionAfterDays, this.categorizationFilters, this.customSettings, this.allowLazyOpen);
        }
    }

    public static class DetectorUpdate
    implements ToXContentObject {
        public static final ConstructingObjectParser<DetectorUpdate, Void> PARSER = new ConstructingObjectParser("detector_update", true, a -> new DetectorUpdate((Integer)a[0], (String)a[1], (List)a[2]));
        private final int detectorIndex;
        private final String description;
        private final List<DetectionRule> rules;

        public DetectorUpdate(int detectorIndex, String description, List<DetectionRule> rules) {
            this.detectorIndex = detectorIndex;
            this.description = description;
            this.rules = rules;
        }

        public int getDetectorIndex() {
            return this.detectorIndex;
        }

        public String getDescription() {
            return this.description;
        }

        public List<DetectionRule> getRules() {
            return this.rules;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Detector.DETECTOR_INDEX.getPreferredName(), this.detectorIndex);
            if (this.description != null) {
                builder.field(Job.DESCRIPTION.getPreferredName(), this.description);
            }
            if (this.rules != null) {
                builder.field(Detector.CUSTOM_RULES_FIELD.getPreferredName(), this.rules);
            }
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.detectorIndex, this.description, this.rules);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            DetectorUpdate that = (DetectorUpdate)other;
            return this.detectorIndex == that.detectorIndex && Objects.equals(this.description, that.description) && Objects.equals(this.rules, that.rules);
        }

        static {
            PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), Detector.DETECTOR_INDEX);
            PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), Job.DESCRIPTION);
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (parser, parseFieldMatcher) -> ((DetectionRule.Builder)DetectionRule.PARSER.apply(parser, parseFieldMatcher)).build(), Detector.CUSTOM_RULES_FIELD);
        }
    }
}

