/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.core.PageParams;
import org.elasticsearch.client.ml.calendars.Calendar;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class GetCalendarsRequest
implements Validatable,
ToXContentObject {
    public static final ObjectParser<GetCalendarsRequest, Void> PARSER = new ObjectParser("get_calendars_request", GetCalendarsRequest::new);
    private String calendarId;
    private PageParams pageParams;

    public GetCalendarsRequest() {
    }

    public GetCalendarsRequest(String calendarId) {
        this.calendarId = calendarId;
    }

    public String getCalendarId() {
        return this.calendarId;
    }

    public void setCalendarId(String calendarId) {
        this.calendarId = calendarId;
    }

    public PageParams getPageParams() {
        return this.pageParams;
    }

    public void setPageParams(PageParams pageParams) {
        this.pageParams = pageParams;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.calendarId != null) {
            builder.field(Calendar.ID.getPreferredName(), this.calendarId);
        }
        if (this.pageParams != null) {
            builder.field(PageParams.PAGE.getPreferredName(), (ToXContent)this.pageParams);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.calendarId, this.pageParams);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetCalendarsRequest other = (GetCalendarsRequest)obj;
        return Objects.equals(this.calendarId, other.calendarId) && Objects.equals(this.pageParams, other.pageParams);
    }

    static {
        PARSER.declareString(GetCalendarsRequest::setCalendarId, Calendar.ID);
        PARSER.declareObject(GetCalendarsRequest::setPageParams, PageParams.PARSER, PageParams.PAGE);
    }
}

