/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security.support;

import java.util.Collection;
import java.util.Objects;
import org.elasticsearch.core.Nullable;

public class ServiceTokenInfo {
    private final String name;
    private final String source;
    @Nullable
    private final Collection<String> nodeNames;

    public ServiceTokenInfo(String name, String source) {
        this(name, source, null);
    }

    public ServiceTokenInfo(String name, String source, Collection<String> nodeNames) {
        this.name = Objects.requireNonNull(name, "token name is required");
        this.source = Objects.requireNonNull(source, "token source is required");
        this.nodeNames = nodeNames;
    }

    public String getName() {
        return this.name;
    }

    public String getSource() {
        return this.source;
    }

    public Collection<String> getNodeNames() {
        return this.nodeNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceTokenInfo that = (ServiceTokenInfo)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.source, that.source) && Objects.equals(this.nodeNames, that.nodeNames);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.source, this.nodeNames);
    }

    public String toString() {
        return "ServiceTokenInfo{name='" + this.name + "', source='" + this.source + "', nodeNames=" + this.nodeNames + "}";
    }
}

